/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.session.AbstractLoginTest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.test.json.JSONAssertion;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.httpclient.Cookie;

public class LoginTest
extends AbstractLoginTest {
    public LoginTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.createClient();
    }

    protected void tearDown() throws Exception {
    }

    public void testSuccessfulLoginReturnsSession() throws Exception {
        this.assertResponseContains("session");
    }

    public void testSuccessfulLoginReturnsRandom() throws Exception {
        this.assertResponseContains("random");
    }

    public void testSuccessfulLoginSetsSecretCookie() throws Exception {
        this.rawLogin("login");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        boolean found = false;
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            found = found || name.startsWith("open-xchange-secret");
        }
        LoginTest.assertTrue((String)("Missing secret cookie: " + ((Object)cookieNames).toString()), (boolean)found);
    }

    public void testSuccessfulLoginDoesNotSetSessionCookie() throws Exception {
        this.rawLogin("login");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        boolean found = false;
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            found = found || name.startsWith("open-xchange-session");
        }
        LoginTest.assertFalse((String)("Found session cookie, but shouldn't have: " + ((Object)cookieNames).toString()), (boolean)found);
    }

    public void testSecretCookiesDifferPerClientID() throws Exception {
        String[] credentials = this.credentials("login");
        this.inModule("login");
        this.raw("login", "name", credentials[0], "password", credentials[1], "client", "testclient1");
        this.raw("login", "name", credentials[0], "password", credentials[1], "client", "testclient2");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        int counter = 0;
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            if (!name.startsWith("open-xchange-secret")) continue;
            ++counter;
        }
        LoginTest.assertTrue((String)("Missing secret cookie: " + ((Object)cookieNames).toString()), (counter == 2 ? 1 : 0) != 0);
    }

    public void testSecretCookieLifetimeIsLongerThanADay() throws Exception {
        this.rawLogin("login");
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        ArrayList<String> cookieNames = new ArrayList<String>(cookies.length);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            cookieNames.add(name);
            if (!name.startsWith("open-xchange-secret")) continue;
            LoginTest.assertNotNull((Object)cookie.getExpiryDate());
            Date tomorrow = TimeTools.D("tomorrow");
            LoginTest.assertTrue((boolean)cookie.getExpiryDate().after(tomorrow));
        }
    }

    public void testSuccessfulLoginAllowsSubsequentRequests() throws Exception {
        this.as("login");
        this.inModule("quota");
        this.call("filestore", new Object[0]);
        this.assertNoError();
    }

    public void testRefreshSecretActionResetsSecretCookieLifetime() throws Exception {
        int i;
        this.rawLogin("login");
        Date oldCookie = null;
        Date newCookie = null;
        Cookie[] cookies = this.currentClient.getClient().getState().getCookies();
        for (i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().startsWith("open-xchange-secret")) continue;
            oldCookie = cookies[i].getExpiryDate();
        }
        Thread.sleep(1000L);
        this.raw("refreshSecret", "session", this.rawResponse.getString("session"));
        cookies = this.currentClient.getClient().getState().getCookies();
        for (i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().startsWith("open-xchange-secret")) continue;
            newCookie = cookies[i].getExpiryDate();
        }
        LoginTest.assertNotNull((String)"Precondition: Should find secret cookie after renewal", newCookie);
        LoginTest.assertNotNull((String)"Precondition: Should find secret cookie first", (Object)oldCookie);
        LoginTest.assertTrue((String)"Refreshed secret cookie should have newer expiry date", (newCookie.compareTo(oldCookie) > 0 ? 1 : 0) != 0);
    }

    public void testWrongCredentials() throws Exception {
        this.inModule("login");
        this.call("login", "name", "foo", "password", "bar");
        this.assertError();
    }

    public void testNonExistingSessionIDOnSubsequentRequests() throws Exception {
        this.as("login");
        this.inModule("quota");
        this.call("filestore", "session", "1234567");
        this.assertError();
    }

    public void testSessionIDAndSecretMismatch() throws Exception {
        this.as("login");
        String sessionID = this.currentClient.getSessionID();
        this.as("seconduser");
        this.inModule("quota");
        this.call("filestore", "session", sessionID);
        this.assertError();
    }

    private void assertResponseContains(String key) throws Exception {
        this.rawLogin("login");
        this.assertRaw(new JSONAssertion().isObject().hasKey(key));
    }

    private void rawLogin(String user) throws Exception {
        String[] credentials = this.credentials(user);
        this.inModule("login");
        this.raw("login", "name", credentials[0], "password", credentials[1]);
    }
}

