/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.groupware.search.Order;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThreadSortTest
extends AbstractMailTest {
    private static final Log LOG = LogFactory.getLog(ThreadSortTest.class);
    String mailObject_25kb;

    public ThreadSortTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        super.tearDown();
    }

    public void testAllThreadSort() throws Throwable {
        int numOfMails = 25;
        LOG.info((Object)"Sending 25 mails to fill emptied INBOX");
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new SendRequest(this.mailObject_25kb));
            LOG.info((Object)("Sent " + (i + 1) + ". mail of " + 25));
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, Order.DESCENDING, true).setThreadSort(true));
        if (allR.hasError()) {
            ThreadSortTest.fail((String)allR.getException().toString());
        }
        Object[][] array = allR.getArray();
        ThreadSortTest.assertNotNull((String)"Array of all request is null.", (Object)array);
        ThreadSortTest.assertEquals((String)"All request shows different number of mails.", (int)25, (int)array.length);
        ThreadSortTest.assertEquals((String)"Number of columns differs from request ones.", (int)COLUMNS_DEFAULT_LIST.length, (int)array[0].length);
        for (int i = 0; i < array.length; ++i) {
            Object[] inner = array[i];
            for (int j = 0; j < inner.length; ++j) {
                int threadLevel = Integer.parseInt(inner[2].toString());
                ThreadSortTest.assertTrue((String)("Illegal thread level value: " + threadLevel), (threadLevel >= 0 ? 1 : 0) != 0);
            }
        }
    }
}

