/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ImportExportParser {
    private ImportExportParser() {
    }

    public static final ImportResult parse(String data) throws JSONException {
        Response response = ResponseParser.parse((String)data);
        JSONObject json = response.getJSON();
        String id = json.optString("id");
        String folderId = json.optString("folder_id");
        long lastModified = json.optLong("last_modified");
        ImportResult retval = new ImportResult(id, folderId, lastModified);
        if (response.getWarnings() != null && response.getWarnings().size() > 0) {
            retval.setException((OXException)((Object)response.getWarnings().get(0)));
        }
        if (response.hasError()) {
            retval.setException(response.getException());
        }
        JSONArray warnings = json.optJSONArray("warnings");
        ArrayList<ConversionWarning> conversionWarnings = new ArrayList<ConversionWarning>();
        if (warnings != null) {
            int size = warnings.length();
            for (int i = 0; i < size; ++i) {
                String message = warnings.getJSONObject(i).getString("error");
                ConversionWarning warning = new ConversionWarning(-1, message, new Object[0]);
                conversionWarnings.add(warning);
            }
            retval.addWarnings(conversionWarnings);
        }
        return retval;
    }
}

