/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonListParser;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.ListID;
import com.openexchange.ajax.framework.ListIDInt;
import com.openexchange.ajax.framework.ListIDString;
import com.openexchange.ajax.framework.ListIDs;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonListRequest
implements AJAXRequest<CommonListResponse> {
    private final String servletPath;
    protected final ListIDs identifier;
    private final int[] columns;
    private final String alias;
    private final boolean failOnError;

    public CommonListRequest(String servletPath, int[][] folderAndObjectIds, int[] columns) {
        this(servletPath, folderAndObjectIds, columns, true);
    }

    public CommonListRequest(String servletPath, int[][] folderAndObjectIds, int[] columns, boolean failOnError) {
        this(servletPath, CommonListRequest.createListIDs(folderAndObjectIds), columns, failOnError);
    }

    private static ListIDs createListIDs(int[][] folderAndObjectIds) {
        ListIDs retval = new ListIDs();
        for (int i = 0; i < folderAndObjectIds.length; ++i) {
            retval.add(new ListIDInt(folderAndObjectIds[i][0], folderAndObjectIds[i][1]));
        }
        return retval;
    }

    public CommonListRequest(String servletPath, String[][] folderAndObjectIds, int[] columns) {
        this(servletPath, folderAndObjectIds, columns, true);
    }

    public CommonListRequest(String servletPath, String[][] folderAndObjectIds, int[] columns, boolean failOnError) {
        this(servletPath, CommonListRequest.createListIDs(folderAndObjectIds), columns, failOnError);
    }

    private static ListIDs createListIDs(String[][] folderAndObjectIds) {
        ListIDs retval = new ListIDs();
        for (int i = 0; i < folderAndObjectIds.length; ++i) {
            retval.add(new ListIDString(folderAndObjectIds[i][0], folderAndObjectIds[i][1]));
        }
        return retval;
    }

    public CommonListRequest(String servletPath, ListIDs identifier, int[] columns, boolean failOnError) {
        this.servletPath = servletPath;
        this.identifier = identifier;
        this.columns = columns;
        this.alias = null;
        this.failOnError = failOnError;
    }

    public CommonListRequest(String servletPath, int[][] folderAndObjectIds, String alias) {
        this(servletPath, folderAndObjectIds, alias, true);
    }

    public CommonListRequest(String servletPath, int[][] folderAndObjectIds, String alias, boolean failOnError) {
        this(servletPath, CommonListRequest.createListIDs(folderAndObjectIds), alias, failOnError);
    }

    public CommonListRequest(String servletPath, String[][] folderAndObjectIds, String alias) {
        this(servletPath, folderAndObjectIds, alias, true);
    }

    public CommonListRequest(String servletPath, String[][] folderAndObjectIds, String alias, boolean failOnError) {
        this(servletPath, CommonListRequest.createListIDs(folderAndObjectIds), alias, failOnError);
    }

    public CommonListRequest(String servletPath, ListIDs identifier, String alias, boolean failOnError) {
        this.servletPath = servletPath;
        this.identifier = identifier;
        this.columns = null;
        this.alias = alias;
        this.failOnError = failOnError;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.identifier.size(); ++i) {
            ListID ids = this.identifier.get(i);
            JSONObject json = new JSONObject();
            json.put("folder", (Object)ids.getFolder());
            json.put("id", (Object)ids.getObject());
            array.put((Object)json);
        }
        return array;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        if (this.columns != null) {
            return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "list"), new AJAXRequest.Parameter("columns", this.columns)};
        }
        if (this.alias != null) {
            return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "list"), new AJAXRequest.Parameter("columns", this.alias)};
        }
        return null;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    public CommonListParser getParser() {
        return new CommonListParser(this.failOnError, this.columns);
    }
}

