/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import org.json.JSONException;
import org.json.JSONObject;

public final class GetResponse
extends AbstractAJAXResponse {
    private FolderObject folder;

    public GetResponse(Response response) {
        super(response);
    }

    public FolderObject getFolder() throws OXException, OXException {
        if (this.hasError()) {
            return null;
        }
        if (null == this.folder) {
            FolderObject parsed = new FolderObject();
            JSONObject data = (JSONObject)this.getData();
            try {
                String tmp;
                if (data.has("id")) {
                    this.rearrangeId(data);
                }
                if (data.has("folder_id") && (tmp = data.getString("folder_id")).startsWith("u:")) {
                    data.put("folder_id", (Object)Integer.toString(3));
                }
            }
            catch (JSONException e) {
                throw OXJSONExceptionCodes.JSON_READ_ERROR.create();
            }
            new FolderParser().parse(parsed, data);
            this.fillInFullName(data, parsed);
            this.folder = parsed;
        }
        return this.folder;
    }

    private void fillInFullName(JSONObject data, FolderObject parsed) {
        if (data.has("full_name")) {
            parsed.setFullName(data.optString("full_name"));
        }
    }

    private void rearrangeId(JSONObject data) throws JSONException {
        try {
            Integer.parseInt(data.getString("id"));
        }
        catch (NumberFormatException x) {
            String id = data.getString("id");
            data.remove("id");
            data.put("full_name", (Object)id);
        }
    }
}

