/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonDeleteParser;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import java.util.List;
import org.json.JSONArray;

public class ClearRequest
extends AbstractFolderRequest<CommonDeleteResponse> {
    private final String[] folderIds;

    public ClearRequest(API api, String[] folderIds) {
        super(api);
        this.folderIds = folderIds;
    }

    public ClearRequest(API api, String folderId) {
        this(api, new String[]{folderId});
    }

    public ClearRequest(API api, int[] folderIds) {
        this(api, ClearRequest.i2s(folderIds));
    }

    public ClearRequest(API api, int folderId) {
        this(api, new int[]{folderId});
    }

    public ClearRequest(API api, FolderObject ... folder) {
        super(api);
        this.folderIds = new String[folder.length];
        for (int i = 0; i < folder.length; ++i) {
            this.folderIds[i] = folder[i].containsObjectID() ? Autoboxing.I((int)folder[i].getObjectID()).toString() : folder[i].getFullName();
        }
    }

    @Override
    public Object getBody() {
        JSONArray array = new JSONArray();
        for (String folderId : this.folderIds) {
            array.put((Object)folderId);
        }
        return array;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "clear"));
    }

    public CommonDeleteParser getParser() {
        return new CommonDeleteParser(true);
    }
}

