/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;

public class ContactSearchTests
extends AbstractManagedContactTest {
    private static final String ALICE = "Alice";
    private static final String BOB_LASTNAME = "Bob";
    private static final String BOB_DISPLAYNAME = "Carol19";

    public ContactSearchTests(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Contact c1 = this.generateContact();
        c1.setSurName(ALICE);
        Contact c2 = this.generateContact();
        c2.setSurName(BOB_LASTNAME);
        c2.setDisplayName(BOB_DISPLAYNAME);
        this.manager.newAction(c1, c2);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSearchByInitial() {
        Contact[] results = this.manager.searchFirstletterAction("B", this.folderID);
        ContactSearchTests.assertEquals((int)1, (int)results.length);
        ContactSearchTests.assertEquals((String)"Should find the right contact", (String)BOB_LASTNAME, (String)results[0].getSurName());
    }

    public void testAsteriskSearch() {
        Contact[] results = this.manager.searchAction("*", this.folderID);
        ContactSearchTests.assertEquals((String)"Should find two contacts", (int)2, (int)results.length);
    }

    public void testSearchWorksOnlyOnDisplayNameByDefault() {
        Contact[] results = this.manager.searchAction("*Bob*", this.folderID);
        ContactSearchTests.assertEquals((String)"Should find no contact when searching for last name", (int)0, (int)results.length);
        results = this.manager.searchAction("*Carol19*", this.folderID);
        ContactSearchTests.assertEquals((String)"Should find one contact when searching for display_name", (int)1, (int)results.length);
    }

    public void testGuiLikeSearch() {
        ContactSearchObject search = new ContactSearchObject();
        search.setFolder(this.folderID);
        String b = BOB_LASTNAME;
        search.setGivenName(b);
        search.setSurname(b);
        search.setDisplayName(b);
        search.setEmail1(b);
        search.setEmail2(b);
        search.setEmail3(b);
        search.setCatgories(b);
        search.setOrSearch(true);
        Contact[] results = this.manager.searchAction(search);
        ContactSearchTests.assertEquals((String)"Should find one contact", (int)1, (int)results.length);
        ContactSearchTests.assertEquals((String)"Should find the right contact", (String)BOB_LASTNAME, (String)results[0].getSurName());
    }
}

