/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;

public class Bug13788Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment update;

    public Bug13788Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 13788 Test");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setStartDate(TimeTools.D("01.10.2009 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setEndDate(TimeTools.D("02.10.2009 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setFullTime(true);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest appointmentInsertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse appointmentInsertResponse = this.getClient().execute(appointmentInsertRequest);
        appointmentInsertResponse.fillAppointment(this.appointment);
        this.update = new Appointment();
        this.update.setObjectID(this.appointment.getObjectID());
        this.update.setParentFolderID(this.appointment.getParentFolderID());
        this.update.setLastModified(this.appointment.getLastModified());
        this.update.setIgnoreConflicts(true);
        this.update.setStartDate(TimeTools.D("03.10.2009 00:00", TimeZone.getTimeZone("UTC")));
        this.update.setEndDate(TimeTools.D("04.10.2009 00:00", TimeZone.getTimeZone("UTC")));
    }

    public void testBug13788() throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(this.update, this.client.getValues().getTimeZone());
        UpdateResponse updateResponse = this.client.execute(updateRequest);
        this.appointment.setLastModified(updateResponse.getTimestamp());
        GetRequest getRequest = new GetRequest(this.appointment.getParentFolderID(), this.appointment.getObjectID());
        GetResponse getResponse = this.client.execute(getRequest);
        Appointment loadedAppointment = getResponse.getAppointment(this.client.getValues().getTimeZone());
        Bug13788Test.assertTrue((String)"Lost fulltime flag.", (boolean)loadedAppointment.getFullTime());
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest appointmentDeleteRequest = new DeleteRequest(this.appointment);
        this.getClient().execute(appointmentDeleteRequest);
        super.tearDown();
    }
}

