/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.databaseold.Database;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import java.util.TimeZone;

public final class Bug11865Test
extends AbstractAJAXSession {
    public Bug11865Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppointmentException() throws Throwable {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateAppointmentFolder();
        TimeZone tz = client.getValues().getTimeZone();
        Appointment series = new Appointment();
        Calendar calendar = TimeTools.createCalendar(tz);
        series.setTitle("Test for bug 11865");
        series.setParentFolderID(folderId);
        series.setIgnoreConflicts(true);
        calendar.set(11, 12);
        series.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        series.setEndDate(calendar.getTime());
        series.setRecurrenceType(1);
        series.setInterval(1);
        series.setOccurrence(5);
        InsertRequest request = new InsertRequest(series, tz);
        CommonInsertResponse response = client.execute(request);
        response.fillObject((DataObject)series);
        try {
            int recurrence_position = 3;
            GetRequest request2 = new GetRequest(folderId, series.getObjectID(), 3);
            GetResponse response2 = client.execute(request2);
            Appointment occurence = response2.getAppointment(tz);
            Appointment exception = new Appointment();
            exception.setObjectID(occurence.getObjectID());
            exception.setParentFolderID(folderId);
            exception.setLastModified(occurence.getLastModified());
            exception.setRecurrencePosition(occurence.getRecurrencePosition());
            exception.setTitle(occurence.getTitle() + "-changed");
            exception.setIgnoreConflicts(true);
            calendar.setTime(occurence.getEndDate());
            exception.setStartDate(calendar.getTime());
            calendar.add(10, 1);
            exception.setEndDate(calendar.getTime());
            UpdateRequest request3 = new UpdateRequest(exception, tz);
            UpdateResponse response3 = client.execute(request3);
            exception.setObjectID(response3.getId());
            exception.setLastModified(response3.getTimestamp());
            series.setLastModified(response3.getTimestamp());
            Appointment exception2 = new Appointment();
            exception2.setObjectID(exception.getObjectID());
            exception2.setParentFolderID(folderId);
            exception2.setLastModified(exception.getLastModified());
            exception2.setRecurrencePosition(1);
            exception2.setTitle(occurence.getTitle() + "-changed2");
            exception2.setIgnoreConflicts(true);
            calendar.setTime(exception.getEndDate());
            exception2.setStartDate(calendar.getTime());
            calendar.add(10, 1);
            exception2.setEndDate(calendar.getTime());
            UpdateRequest request4 = new UpdateRequest(exception2, tz, false);
            UpdateResponse response4 = client.execute(request4);
            Bug11865Test.assertTrue((String)"Exception expected for creating exception from exception.", (boolean)response4.hasError());
        }
        finally {
            client.execute(new DeleteRequest(series.getObjectID(), folderId, series.getLastModified()));
        }
    }

    public void testDeleteBadData() throws Throwable {
        AJAXClient client = null;
        int objectId = 0;
        int folderId = 0;
        client = this.getClient();
        TimeZone tz = client.getValues().getTimeZone();
        folderId = client.getValues().getPrivateAppointmentFolder();
        Appointment dummyAppointment = new Appointment();
        dummyAppointment.setTitle("bug 11865 dummy appointment");
        dummyAppointment.setParentFolderID(folderId);
        dummyAppointment.setIgnoreConflicts(true);
        Calendar calendar = TimeTools.createCalendar(tz);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(11, 8);
        dummyAppointment.setStartDate(calendar.getTime());
        calendar.set(11, 9);
        dummyAppointment.setEndDate(calendar.getTime());
        InsertRequest request = new InsertRequest(dummyAppointment, tz);
        CommonInsertResponse response = client.execute(request);
        dummyAppointment.setObjectID(response.getId());
        dummyAppointment.setLastModified(response.getTimestamp());
        int dummyId = dummyAppointment.getObjectID();
        DeleteRequest deleteRequest = new DeleteRequest(dummyAppointment.getObjectID(), folderId, dummyAppointment.getLastModified());
        client.execute(deleteRequest);
        Appointment appointment = new Appointment();
        appointment.setTitle("Bug 11865 Corrupted Data Appointment.");
        appointment.setParentFolderID(folderId);
        appointment.setIgnoreConflicts(true);
        calendar = TimeTools.createCalendar(tz);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(11, 8);
        appointment.setStartDate(calendar.getTime());
        calendar.set(11, 9);
        appointment.setEndDate(calendar.getTime());
        request = new InsertRequest(appointment, tz);
        response = client.execute(request);
        appointment.setObjectID(response.getId());
        appointment.setLastModified(response.getTimestamp());
        objectId = appointment.getObjectID();
        calendar = TimeTools.createCalendar(TimeZone.getTimeZone("GMT"));
        ContextStorage ctxStorage = ContextStorage.getInstance();
        String context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        int contextId = ctxStorage.getContextId(context);
        Connection writeCon = Database.get((int)contextId, (boolean)true);
        String sql = "UPDATE prg_dates SET intfield02 = ?, field08 = ? WHERE intfield01 = ?";
        PreparedStatement pstmt = writeCon.prepareStatement("UPDATE prg_dates SET intfield02 = ?, field08 = ? WHERE intfield01 = ?");
        pstmt.setInt(1, dummyId);
        pstmt.setString(2, Long.toString(calendar.getTimeInMillis()));
        pstmt.setInt(3, objectId);
        pstmt.execute();
        pstmt.close();
        Database.back((int)contextId, (boolean)true, (Connection)writeCon);
        deleteRequest = new DeleteRequest(appointment.getObjectID(), folderId, appointment.getLastModified());
        try {
            client.execute(deleteRequest);
        }
        catch (Exception e) {
            Bug11865Test.fail((String)"Exception during deletion of corrupted appointment.");
        }
        GetRequest getRequest = new GetRequest(folderId, appointment.getObjectID(), false);
        GetResponse getResponse = client.execute(getRequest);
        Response r = getResponse.getResponse();
        Bug11865Test.assertTrue((boolean)r.hasError());
        Bug11865Test.assertTrue((boolean)r.getErrorMessage().contains("Object not found"));
    }
}

