/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.parser.ParticipantParser;
import com.openexchange.calendar.storage.ParticipantStorage;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfirmationsTest
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 20, 226};
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private Appointment appointment;
    private ExternalUserParticipant participant;

    public ConfirmationsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setTitle("Test appointment for testing confirmations");
        Calendar calendar = TimeTools.createCalendar(this.tz);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.setParentFolderID(this.folderId);
        this.appointment.setIgnoreConflicts(true);
        this.participant = new ExternalUserParticipant("external1@example.com");
        this.participant.setDisplayName("External user");
        this.appointment.addParticipant((Participant)this.participant);
        this.participant = new ExternalUserParticipant("external2@example.com");
        this.participant.setDisplayName("External user 2");
        this.appointment.addParticipant((Participant)this.participant);
        this.client.execute(new InsertRequest(this.appointment, this.tz)).fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testGet() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(this.appointment));
        Appointment test = response.getAppointment(this.tz);
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), test.getConfirmations());
    }

    private void checkConfirmations(ExternalUserParticipant[] expected, ConfirmableParticipant[] actual) {
        ConfirmationsTest.assertNotNull((String)"Response does not contain any confirmations.", (Object)actual);
        ConfirmationsTest.assertEquals((String)"Number of external participant confirmations does not match.", (int)expected.length, (int)actual.length);
        Arrays.sort(expected);
        Arrays.sort(actual);
        for (int i = 0; i < expected.length; ++i) {
            ConfirmationsTest.assertEquals((String)"Mailaddress of external participant does not match.", (String)expected[i].getEmailAddress(), (String)actual[i].getEmailAddress());
            ConfirmationsTest.assertEquals((String)"Display name of external participant does not match.", (String)expected[i].getDisplayName(), (String)actual[i].getDisplayName());
            ConfirmationsTest.assertEquals((String)"Confirm status does not match.", (Object)expected[i].getStatus(), (Object)actual[i].getStatus());
            ConfirmationsTest.assertEquals((String)"Confirm message does not match.", (String)expected[i].getMessage(), (String)actual[i].getMessage());
        }
    }

    public void testAll() throws Throwable {
        CommonAllResponse response = this.client.execute(new AllRequest(this.folderId, COLUMNS, this.appointment.getStartDate(), this.appointment.getEndDate(), this.tz));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), this.findConfirmations(response));
    }

    private JSONArray findConfirmations(AbstractColumnsResponse response) {
        int objectIdPos = response.getColumnPos(1);
        int confirmationsPos = response.getColumnPos(226);
        JSONArray jsonConfirmations = null;
        for (Object[] tmp : response) {
            if (this.appointment.getObjectID() != ((Integer)tmp[objectIdPos]).intValue()) continue;
            jsonConfirmations = (JSONArray)tmp[confirmationsPos];
        }
        return jsonConfirmations;
    }

    public void testList() throws Throwable {
        CommonListResponse response = this.client.execute(new ListRequest(ListIDs.l(new int[][]{{this.folderId, this.appointment.getObjectID()}}), COLUMNS));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), this.findConfirmations(response));
    }

    public void testSearch() throws Throwable {
        SearchResponse response = this.client.execute(new SearchRequest("*", this.folderId, COLUMNS));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])this.appointment.getParticipants()), this.findConfirmations(response));
    }

    private void checkConfirmations(ExternalUserParticipant[] expected, JSONArray jsonConfirmations) throws JSONException {
        ConfirmationsTest.assertNotNull((String)"Response does not contain confirmations.", (Object)jsonConfirmations);
        ParticipantParser parser = new ParticipantParser();
        ArrayList<ConfirmableParticipant> confirmations = new ArrayList<ConfirmableParticipant>();
        int length = jsonConfirmations.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonConfirmation = jsonConfirmations.getJSONObject(i);
            confirmations.add(parser.parseConfirmation(true, jsonConfirmation));
        }
        this.checkConfirmations(expected, confirmations.toArray(new ConfirmableParticipant[confirmations.size()]));
    }

    public void testUpdate() throws Throwable {
        Appointment updated = new Appointment();
        updated.setObjectID(this.appointment.getObjectID());
        updated.setParentFolderID(this.appointment.getParentFolderID());
        updated.setLastModified(this.appointment.getLastModified());
        updated.setTitle("Updated test appointment for testing confirmations");
        updated.setIgnoreConflicts(true);
        this.participant = new ExternalUserParticipant("external1@example.com");
        this.participant.setDisplayName("External user");
        updated.addParticipant((Participant)this.participant);
        this.participant = new ExternalUserParticipant("external3@example.com");
        this.participant.setDisplayName("External user 3");
        updated.addParticipant((Participant)this.participant);
        UpdateResponse response = this.client.execute(new UpdateRequest(updated, this.tz));
        this.appointment.setLastModified(response.getTimestamp());
        GetResponse response2 = this.client.execute(new GetRequest(this.appointment));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])updated.getParticipants()), response2.getAppointment(this.tz).getConfirmations());
        CommonAllResponse response3 = this.client.execute(new AllRequest(this.folderId, COLUMNS, this.appointment.getStartDate(), this.appointment.getEndDate(), this.tz));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])updated.getParticipants()), this.findConfirmations(response3));
        CommonListResponse response4 = this.client.execute(new ListRequest(ListIDs.l(new int[][]{{this.folderId, this.appointment.getObjectID()}}), COLUMNS));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])updated.getParticipants()), this.findConfirmations(response4));
        SearchResponse response5 = this.client.execute(new SearchRequest("*", this.folderId, COLUMNS));
        this.checkConfirmations(ParticipantStorage.extractExternal((Participant[])updated.getParticipants()), this.findConfirmations(response5));
    }
}

