/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.writer;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.user.json.Utility;
import com.openexchange.user.json.field.DistributionListField;
import com.openexchange.user.json.field.UserField;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class UserWriter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UserWriter.class));
    private static final boolean WARN = LOG.isWarnEnabled();
    private static final UserFieldWriter UNKNOWN_FIELD_FFW = new UserFieldWriter(){

        @Override
        public void writeField(JSONValuePutter jsonValue, User user, Contact contact) throws JSONException {
            jsonValue.put("unknown_field", JSONObject.NULL);
        }
    };
    private static final TIntObjectMap<UserFieldWriter> STATIC_WRITERS_MAP;
    private static final int[] ALL_FIELDS;
    private static final String ALL = "*";
    private static final int AVERAGE_ATTR_PARAMS_SIZE = 4;

    private UserWriter() {
    }

    private static UserFieldWriter getUserFieldWriter(int field, final String timeZoneId) {
        if (null == timeZoneId) {
            return (UserFieldWriter)STATIC_WRITERS_MAP.get(field);
        }
        if (UserField.CREATION_DATE.getColumn() == field) {
            return new UserFieldWriter(){

                @Override
                public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                    Date d = contact.getCreationDate();
                    jsonPutter.put(UserField.CREATION_DATE.getName(), null == d ? JSONObject.NULL : Long.valueOf(Utility.addTimeZoneOffset(d.getTime(), timeZoneId)));
                }
            };
        }
        if (UserField.LAST_MODIFIED.getColumn() == field) {
            return new UserFieldWriter(){

                @Override
                public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                    Date d = contact.getCreationDate();
                    jsonPutter.put(UserField.LAST_MODIFIED.getName(), null == d ? JSONObject.NULL : Long.valueOf(Utility.addTimeZoneOffset(d.getTime(), timeZoneId)));
                }
            };
        }
        return (UserFieldWriter)STATIC_WRITERS_MAP.get(field);
    }

    private static void addAttributeWriters(Map<String, List<String>> attributeParameters, List<UserFieldWriter> ufws) {
        if (null == attributeParameters || attributeParameters.isEmpty()) {
            return;
        }
        int size = attributeParameters.size();
        Iterator<Map.Entry<String, List<String>>> iter = attributeParameters.entrySet().iterator();
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < size; ++i) {
            Map.Entry<String, List<String>> entry = iter.next();
            List<String> list = entry.getValue();
            if (list.isEmpty()) continue;
            if (1 == list.size() && ALL.equals(list.get(0))) {
                ufws.add(new WildcardAttributeUserFieldWriter(entry.getKey()));
                continue;
            }
            String prefix = entry.getKey();
            int pLen = prefix.length() + 1;
            sb.setLength(0);
            sb.append(prefix).append('/');
            for (String appendix : list) {
                sb.setLength(pLen);
                sb.append(appendix);
                ufws.add(new AttributeUserFieldWriter(sb.toString()));
            }
        }
    }

    public static JSONArray writeSingle2Array(int[] fields, Map<String, List<String>> attributeParameters, User user, Contact contact, String timeZoneId) throws OXException {
        int[] cols = null == fields ? ALL_FIELDS : fields;
        ArrayList<UserFieldWriter> ufws = new ArrayList<UserFieldWriter>(cols.length + 4);
        for (int col : cols) {
            UserFieldWriter ufw = UserWriter.getUserFieldWriter(col, timeZoneId);
            if (null == ufw) {
                if (WARN) {
                    LOG.warn((Object)("Unknown field: " + col), new Throwable());
                }
                ufw = UNKNOWN_FIELD_FFW;
            }
            ufws.add(ufw);
        }
        UserWriter.addAttributeWriters(attributeParameters, ufws);
        try {
            JSONArray jsonArray = new JSONArray();
            JSONArrayPutter jsonPutter = new JSONArrayPutter(jsonArray);
            for (UserFieldWriter ufw : ufws) {
                ufw.writeField(jsonPutter, user, contact);
            }
            return jsonArray;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static JSONArray writeMultiple2Array(int[] fields, Map<String, List<String>> attributeParameters, User[] users, Contact[] contacts, String timeZoneId) throws OXException {
        int[] cols = null == fields ? ALL_FIELDS : fields;
        ArrayList<UserFieldWriter> ufws = new ArrayList<UserFieldWriter>(cols.length + 4);
        for (int col : cols) {
            UserFieldWriter ufw = UserWriter.getUserFieldWriter(col, timeZoneId);
            if (null == ufw) {
                if (WARN) {
                    LOG.warn((Object)("Unknown field: " + col), new Throwable());
                }
                ufw = UNKNOWN_FIELD_FFW;
            }
            ufws.add(ufw);
        }
        UserWriter.addAttributeWriters(attributeParameters, ufws);
        try {
            JSONArray jsonArray = new JSONArray();
            JSONArrayPutter jsonPutter = new JSONArrayPutter();
            for (int i = 0; i < users.length; ++i) {
                JSONArray folderArray = new JSONArray();
                jsonPutter.setJSONArray(folderArray);
                for (UserFieldWriter ufw : ufws) {
                    ufw.writeField(jsonPutter, users[i], contacts[i]);
                }
                jsonArray.put((Object)folderArray);
            }
            return jsonArray;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static JSONObject writeSingle2Object(int[] fields, Map<String, List<String>> attributeParameters, User user, Contact contact, String timeZoneId) throws OXException {
        int[] cols = null == fields ? ALL_FIELDS : fields;
        ArrayList<UserFieldWriter> ufws = new ArrayList<UserFieldWriter>(cols.length + 4);
        for (int col : cols) {
            UserFieldWriter ufw = UserWriter.getUserFieldWriter(col, timeZoneId);
            if (null == ufw) {
                if (WARN) {
                    LOG.warn((Object)("Unknown field: " + col), new Throwable());
                }
                ufw = UNKNOWN_FIELD_FFW;
            }
            ufws.add(ufw);
        }
        UserWriter.addAttributeWriters(attributeParameters, ufws);
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObjectPutter jsonPutter = new JSONObjectPutter(jsonObject);
            for (UserFieldWriter ufw : ufws) {
                ufw.writeField(jsonPutter, user, contact);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public static JSONArray writeMultiple2Object(int[] fields, Map<String, List<String>> attributeParameters, User[] users, Contact[] contacts, String timeZoneId) throws OXException {
        int[] cols = null == fields ? ALL_FIELDS : fields;
        ArrayList<UserFieldWriter> ufws = new ArrayList<UserFieldWriter>(cols.length + 4);
        for (int col : cols) {
            UserFieldWriter ufw = UserWriter.getUserFieldWriter(col, timeZoneId);
            if (null == ufw) {
                if (WARN) {
                    LOG.warn((Object)("Unknown field: " + col), new Throwable());
                }
                ufw = UNKNOWN_FIELD_FFW;
            }
            ufws.add(ufw);
        }
        UserWriter.addAttributeWriters(attributeParameters, ufws);
        try {
            JSONArray jsonArray = new JSONArray();
            JSONObjectPutter jsonPutter = new JSONObjectPutter();
            for (int i = 0; i < users.length; ++i) {
                JSONObject folderObject = new JSONObject();
                jsonPutter.setJSONObject(folderObject);
                for (UserFieldWriter ufw : ufws) {
                    ufw.writeField(jsonPutter, users[i], contacts[i]);
                }
                jsonArray.put((Object)folderObject);
            }
            return jsonArray;
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap();
        m.put(UserField.ID.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.ID.getName(), user.getId());
            }
        });
        m.put(UserField.CREATED_BY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                int createdBy = contact.getCreatedBy();
                jsonPutter.put(UserField.CREATED_BY.getName(), -1 == createdBy ? JSONObject.NULL : Integer.valueOf(createdBy));
            }
        });
        m.put(UserField.MODIFIED_BY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                int modifiedBy = contact.getModifiedBy();
                jsonPutter.put(UserField.MODIFIED_BY.getName(), -1 == modifiedBy ? JSONObject.NULL : Integer.valueOf(modifiedBy));
            }
        });
        m.put(UserField.CREATION_DATE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                Date d = contact.getCreationDate();
                jsonPutter.put(UserField.CREATION_DATE.getName(), null == d ? JSONObject.NULL : Long.valueOf(Utility.addTimeZoneOffset(d.getTime(), user.getTimeZone())));
            }
        });
        m.put(UserField.LAST_MODIFIED.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                Date d = contact.getLastModified();
                jsonPutter.put(UserField.LAST_MODIFIED.getName(), null == d ? JSONObject.NULL : Long.valueOf(Utility.addTimeZoneOffset(d.getTime(), user.getTimeZone())));
            }
        });
        m.put(UserField.LAST_MODIFIED_UTC.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                Date d = contact.getLastModified();
                jsonPutter.put(UserField.LAST_MODIFIED_UTC.getName(), null == d ? JSONObject.NULL : Long.valueOf(d.getTime()));
            }
        });
        m.put(UserField.FOLDER_ID.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                int pid = contact.getParentFolderID();
                jsonPutter.put(UserField.FOLDER_ID.getName(), pid <= 0 ? JSONObject.NULL : Integer.valueOf(pid));
            }
        });
        m.put(UserField.CATEGORIES.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCategories();
                jsonPutter.put(UserField.CATEGORIES.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.PRIVATE_FLAG.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.PRIVATE_FLAG.getName(), contact.getPrivateFlag());
            }
        });
        m.put(UserField.COLOR_LABEL.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.COLOR_LABEL.getName(), contact.getLabel());
            }
        });
        m.put(UserField.NUMBER_OF_ATTACHMENTS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.NUMBER_OF_ATTACHMENTS.getName(), contact.getNumberOfAttachments());
            }
        });
        m.put(UserField.DISPLAY_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String name = contact.getDisplayName();
                jsonPutter.put(UserField.DISPLAY_NAME.getName(), name);
            }
        });
        m.put(UserField.FIRST_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getGivenName();
                jsonPutter.put(UserField.FIRST_NAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.LAST_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getSurName();
                jsonPutter.put(UserField.LAST_NAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.SECOND_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getMiddleName();
                jsonPutter.put(UserField.SECOND_NAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.SUFFIX.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getSuffix();
                jsonPutter.put(UserField.SUFFIX.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TITLE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTitle();
                jsonPutter.put(UserField.TITLE.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.STREET_HOME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getStreetHome();
                jsonPutter.put(UserField.STREET_HOME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.POSTAL_CODE_HOME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getPostalCodeHome();
                jsonPutter.put(UserField.POSTAL_CODE_HOME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.CITY_HOME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCityHome();
                jsonPutter.put(UserField.CITY_HOME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.STATE_HOME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getStateHome();
                jsonPutter.put(UserField.STATE_HOME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.COUNTRY_HOME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCountryHome();
                jsonPutter.put(UserField.COUNTRY_HOME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.BIRTHDAY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                Date d = contact.getBirthday();
                jsonPutter.put(UserField.BIRTHDAY.getName(), null == d ? JSONObject.NULL : Long.valueOf(d.getTime()));
            }
        });
        m.put(UserField.MARITAL_STATUS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getMaritalStatus();
                jsonPutter.put(UserField.MARITAL_STATUS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.NUMBER_OF_CHILDREN.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getNumberOfChildren();
                jsonPutter.put(UserField.NUMBER_OF_CHILDREN.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.PROFESSION.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getProfession();
                jsonPutter.put(UserField.PROFESSION.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.NICKNAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getNickname();
                jsonPutter.put(UserField.NICKNAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.SPOUSE_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getSpouseName();
                jsonPutter.put(UserField.SPOUSE_NAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.ANNIVERSARY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                Date d = contact.getAnniversary();
                jsonPutter.put(UserField.ANNIVERSARY.getName(), null == d ? JSONObject.NULL : Long.valueOf(d.getTime()));
            }
        });
        m.put(UserField.NOTE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getNote();
                jsonPutter.put(UserField.NOTE.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.DEFAULT_ADDRESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                int i = contact.getDefaultAddress();
                jsonPutter.put(UserField.DEFAULT_ADDRESS.getName(), i);
            }
        });
        m.put(UserField.DEPARTMENT.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getDepartment();
                jsonPutter.put(UserField.DEPARTMENT.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.POSITION.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getPosition();
                jsonPutter.put(UserField.POSITION.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.EMPLOYEE_TYPE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getEmployeeType();
                jsonPutter.put(UserField.EMPLOYEE_TYPE.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.ROOM_NUMBER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getRoomNumber();
                jsonPutter.put(UserField.ROOM_NUMBER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.STREET_BUSINESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getStreetBusiness();
                jsonPutter.put(UserField.STREET_BUSINESS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.POSTAL_CODE_BUSINESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getPostalCodeBusiness();
                jsonPutter.put(UserField.POSTAL_CODE_BUSINESS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.CITY_BUSINESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCityBusiness();
                jsonPutter.put(UserField.CITY_BUSINESS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.INTERNAL_USERID.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.INTERNAL_USERID.getName(), user.getId());
            }
        });
        m.put(UserField.STATE_BUSINESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getStateBusiness();
                jsonPutter.put(UserField.STATE_BUSINESS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.COUNTRY_BUSINESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCountryBusiness();
                jsonPutter.put(UserField.COUNTRY_BUSINESS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.NUMBER_OF_EMPLOYEE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getNumberOfEmployee();
                jsonPutter.put(UserField.NUMBER_OF_EMPLOYEE.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.SALES_VOLUME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getSalesVolume();
                jsonPutter.put(UserField.SALES_VOLUME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TAX_ID.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTaxID();
                jsonPutter.put(UserField.TAX_ID.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.COMMERCIAL_REGISTER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCommercialRegister();
                jsonPutter.put(UserField.COMMERCIAL_REGISTER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.BRANCHES.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getBranches();
                jsonPutter.put(UserField.BRANCHES.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.BUSINESS_CATEGORY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getBusinessCategory();
                jsonPutter.put(UserField.BUSINESS_CATEGORY.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.INFO.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getInfo();
                jsonPutter.put(UserField.INFO.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.MANAGER_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getManagerName();
                jsonPutter.put(UserField.MANAGER_NAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.ASSISTANT_NAME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getAssistantName();
                jsonPutter.put(UserField.ASSISTANT_NAME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.STREET_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getStreetOther();
                jsonPutter.put(UserField.STREET_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.CITY_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCityOther();
                jsonPutter.put(UserField.CITY_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.STATE_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getStateOther();
                jsonPutter.put(UserField.STATE_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.POSTAL_CODE_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getPostalCodeOther();
                jsonPutter.put(UserField.POSTAL_CODE_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.COUNTRY_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCountryOther();
                jsonPutter.put(UserField.COUNTRY_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_BUSINESS1.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneBusiness1();
                jsonPutter.put(UserField.TELEPHONE_BUSINESS1.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_BUSINESS2.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneBusiness2();
                jsonPutter.put(UserField.TELEPHONE_BUSINESS2.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.FAX_BUSINESS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getFaxBusiness();
                jsonPutter.put(UserField.FAX_BUSINESS.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_CALLBACK.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneCallback();
                jsonPutter.put(UserField.TELEPHONE_CALLBACK.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_CAR.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneCar();
                jsonPutter.put(UserField.TELEPHONE_CAR.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_COMPANY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneCompany();
                jsonPutter.put(UserField.TELEPHONE_COMPANY.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_HOME1.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneHome1();
                jsonPutter.put(UserField.TELEPHONE_HOME1.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_HOME2.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneHome2();
                jsonPutter.put(UserField.TELEPHONE_HOME2.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.FAX_HOME.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getFaxHome();
                jsonPutter.put(UserField.FAX_HOME.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.CELLULAR_TELEPHONE1.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCellularTelephone1();
                jsonPutter.put(UserField.CELLULAR_TELEPHONE1.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.CELLULAR_TELEPHONE2.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCellularTelephone2();
                jsonPutter.put(UserField.CELLULAR_TELEPHONE2.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneOther();
                jsonPutter.put(UserField.TELEPHONE_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.FAX_OTHER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getFaxOther();
                jsonPutter.put(UserField.FAX_OTHER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.EMAIL1.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getEmail1();
                jsonPutter.put(UserField.EMAIL1.getName(), null == s ? JSONObject.NULL : Tools.toIDN((String)s));
            }
        });
        m.put(UserField.EMAIL2.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getEmail2();
                jsonPutter.put(UserField.EMAIL2.getName(), null == s ? JSONObject.NULL : Tools.toIDN((String)s));
            }
        });
        m.put(UserField.EMAIL3.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getEmail3();
                jsonPutter.put(UserField.EMAIL3.getName(), null == s ? JSONObject.NULL : Tools.toIDN((String)s));
            }
        });
        m.put(UserField.TELEPHONE_ISDN.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneISDN();
                jsonPutter.put(UserField.TELEPHONE_ISDN.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_PAGER.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephonePager();
                jsonPutter.put(UserField.TELEPHONE_PAGER.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_PRIMARY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephonePrimary();
                jsonPutter.put(UserField.TELEPHONE_PRIMARY.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_TELEX.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneTelex();
                jsonPutter.put(UserField.TELEPHONE_TELEX.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_RADIO.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneRadio();
                jsonPutter.put(UserField.TELEPHONE_RADIO.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_TTYTDD.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneTTYTTD();
                jsonPutter.put(UserField.TELEPHONE_TTYTDD.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.INSTANT_MESSENGER1.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getInstantMessenger1();
                jsonPutter.put(UserField.INSTANT_MESSENGER1.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.INSTANT_MESSENGER2.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getInstantMessenger2();
                jsonPutter.put(UserField.INSTANT_MESSENGER2.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_IP.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneIP();
                jsonPutter.put(UserField.TELEPHONE_IP.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.TELEPHONE_ASSISTANT.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getTelephoneAssistant();
                jsonPutter.put(UserField.TELEPHONE_ASSISTANT.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.COMPANY.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getCompany();
                jsonPutter.put(UserField.COMPANY.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.IMAGE1.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.IMAGE1.getName(), JSONObject.NULL);
            }
        });
        m.put(UserField.USERFIELD01.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField01();
                jsonPutter.put(UserField.USERFIELD01.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD02.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField02();
                jsonPutter.put(UserField.USERFIELD02.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD03.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField03();
                jsonPutter.put(UserField.USERFIELD03.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD04.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField04();
                jsonPutter.put(UserField.USERFIELD04.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD05.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField05();
                jsonPutter.put(UserField.USERFIELD05.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD06.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField06();
                jsonPutter.put(UserField.USERFIELD06.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD07.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField07();
                jsonPutter.put(UserField.USERFIELD07.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD08.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField08();
                jsonPutter.put(UserField.USERFIELD08.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD09.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField09();
                jsonPutter.put(UserField.USERFIELD09.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD10.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField10();
                jsonPutter.put(UserField.USERFIELD10.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD11.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField11();
                jsonPutter.put(UserField.USERFIELD11.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD12.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField12();
                jsonPutter.put(UserField.USERFIELD12.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD13.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField13();
                jsonPutter.put(UserField.USERFIELD13.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD14.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField14();
                jsonPutter.put(UserField.USERFIELD14.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD15.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField15();
                jsonPutter.put(UserField.USERFIELD15.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD16.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField16();
                jsonPutter.put(UserField.USERFIELD16.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD17.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField17();
                jsonPutter.put(UserField.USERFIELD17.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD18.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField18();
                jsonPutter.put(UserField.USERFIELD18.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD19.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField19();
                jsonPutter.put(UserField.USERFIELD19.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USERFIELD20.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getUserField20();
                jsonPutter.put(UserField.USERFIELD20.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.LINKS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                LinkEntryObject[] links = contact.getLinks();
                if (null == links || 0 == links.length) {
                    jsonPutter.put(UserField.LINKS.getName(), JSONObject.NULL);
                } else {
                    JSONArray jsonArray = new JSONArray();
                    for (LinkEntryObject link : links) {
                        JSONObject jsonLinkObject = new JSONObject();
                        if (link.containsLinkID()) {
                            jsonLinkObject.put(UserField.ID.getName(), link.getLinkID());
                        }
                        jsonLinkObject.put(UserField.DISPLAY_NAME.getName(), (Object)link.getLinkDisplayname());
                        jsonArray.put((Object)jsonLinkObject);
                    }
                    jsonPutter.put(UserField.LINKS.getName(), jsonArray);
                }
            }
        });
        m.put(UserField.DISTRIBUTIONLIST.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                DistributionListEntryObject[] distributionList = contact.getDistributionList();
                if (null == distributionList || 0 == distributionList.length) {
                    jsonPutter.put(UserField.DISTRIBUTIONLIST.getName(), JSONObject.NULL);
                } else {
                    JSONArray jsonArray = new JSONArray();
                    for (DistributionListEntryObject listEntry : distributionList) {
                        String s;
                        JSONObject jsonDListObj = new JSONObject();
                        int emailField = listEntry.getEmailfield();
                        if (emailField != 0) {
                            jsonDListObj.put(UserField.ID.getName(), listEntry.getEntryID());
                        }
                        if (null != (s = listEntry.getEmailaddress()) && s.length() > 0) {
                            jsonDListObj.put(DistributionListField.MAIL.getName(), (Object)s);
                        }
                        if (null != (s = listEntry.getDisplayname()) && s.length() > 0) {
                            jsonDListObj.put(UserField.DISPLAY_NAME.getName(), (Object)s);
                        }
                        jsonDListObj.put(DistributionListField.MAIL_FIELD.getName(), emailField);
                        jsonArray.put((Object)jsonDListObj);
                    }
                    jsonPutter.put(UserField.DISTRIBUTIONLIST.getName(), jsonArray);
                }
            }
        });
        m.put(UserField.MARK_AS_DISTRIBUTIONLIST.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                if (contact.containsMarkAsDistributionlist()) {
                    jsonPutter.put(UserField.MARK_AS_DISTRIBUTIONLIST.getName(), contact.getMarkAsDistribtuionlist());
                } else {
                    jsonPutter.put(UserField.MARK_AS_DISTRIBUTIONLIST.getName(), JSONObject.NULL);
                }
            }
        });
        m.put(UserField.URL.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = contact.getURL();
                jsonPutter.put(UserField.URL.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.USE_COUNT.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.USE_COUNT.getName(), contact.getUseCount());
            }
        });
        m.put(UserField.NUMBER_OF_LINKS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.NUMBER_OF_LINKS.getName(), contact.getNumberOfLinks());
            }
        });
        m.put(UserField.NUMBER_OF_DISTRIBUTIONLIST.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.NUMBER_OF_DISTRIBUTIONLIST.getName(), contact.getNumberOfDistributionLists());
            }
        });
        m.put(UserField.ALIASES.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String[] aliases = user.getAliases();
                if (null == aliases || 0 == aliases.length) {
                    jsonPutter.put(UserField.ALIASES.getName(), JSONObject.NULL);
                } else {
                    JSONArray aliasesArray = new JSONArray();
                    for (String alias : aliases) {
                        aliasesArray.put((Object)alias);
                    }
                    jsonPutter.put(UserField.ALIASES.getName(), aliasesArray);
                }
            }
        });
        m.put(UserField.TIME_ZONE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = user.getTimeZone();
                jsonPutter.put(UserField.TIME_ZONE.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        m.put(UserField.LOCALE.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                Locale l = user.getLocale();
                jsonPutter.put(UserField.LOCALE.getName(), null == l ? JSONObject.NULL : l.toString());
            }
        });
        m.put(UserField.GROUPS.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                int[] groups = user.getGroups();
                if (null == groups || 0 == groups.length) {
                    jsonPutter.put(UserField.GROUPS.getName(), JSONObject.NULL);
                } else {
                    JSONArray groupsArray = new JSONArray();
                    for (int group : groups) {
                        groupsArray.put(group);
                    }
                    jsonPutter.put(UserField.GROUPS.getName(), groupsArray);
                }
            }
        });
        m.put(UserField.CONTACT_ID.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                jsonPutter.put(UserField.CONTACT_ID.getName(), user.getContactId());
            }
        });
        m.put(UserField.LOGIN_INFO.getColumn(), (Object)new UserFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonPutter, User user, Contact contact) throws JSONException {
                String s = user.getLoginInfo();
                jsonPutter.put(UserField.LOGIN_INFO.getName(), null == s ? JSONObject.NULL : s);
            }
        });
        STATIC_WRITERS_MAP = m;
        ALL_FIELDS = new int[UserField.ALL_FIELDS.length];
        int i = 0;
        for (UserField userField : UserField.ALL_FIELDS) {
            UserWriter.ALL_FIELDS[i++] = userField.getColumn();
        }
    }

    private static final class WildcardAttributeUserFieldWriter
    implements UserFieldWriter {
        private final String attributePrefix;

        WildcardAttributeUserFieldWriter(String attributePrefix) {
            this.attributePrefix = attributePrefix;
        }

        @Override
        public void writeField(JSONValuePutter jsonValue, User user, Contact contact) throws JSONException {
            jsonValue.put(this.attributePrefix, this.toJSONValue(user.getAttributes()));
        }

        private Object toJSONValue(Map<String, Set<String>> attributes) throws JSONException {
            if (null == attributes || attributes.isEmpty()) {
                return JSONObject.NULL;
            }
            JSONObject jo = new JSONObject();
            int size = attributes.size();
            Iterator<Map.Entry<String, Set<String>>> iter = attributes.entrySet().iterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, Set<String>> entry = iter.next();
                String key = entry.getKey();
                if (!key.startsWith(this.attributePrefix)) continue;
                jo.put(key, WildcardAttributeUserFieldWriter.set2JSONValue(entry.getValue()));
            }
            return jo;
        }

        private static Object set2JSONValue(Set<String> values) {
            if (null == values || values.isEmpty()) {
                return JSONObject.NULL;
            }
            if (values.size() > 1) {
                JSONArray ja = new JSONArray();
                for (String value : values) {
                    ja.put((Object)value);
                }
                return ja;
            }
            return values.iterator().next();
        }
    }

    private static final class AttributeUserFieldWriter
    implements UserFieldWriter {
        private final String attributeName;

        AttributeUserFieldWriter(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void writeField(JSONValuePutter jsonValue, User user, Contact contact) throws JSONException {
            jsonValue.put(this.attributeName, AttributeUserFieldWriter.toJSONValue((Set)user.getAttributes().get(this.attributeName)));
        }

        private static Object toJSONValue(Set<String> values) {
            if (null == values || values.isEmpty()) {
                return JSONObject.NULL;
            }
            if (values.size() > 1) {
                JSONArray ja = new JSONArray();
                for (String value : values) {
                    ja.put((Object)value);
                }
                return ja;
            }
            return values.iterator().next();
        }
    }

    private static interface UserFieldWriter {
        public void writeField(JSONValuePutter var1, User var2, Contact var3) throws JSONException;
    }

    private static final class JSONObjectPutter
    implements JSONValuePutter {
        private JSONObject jsonObject;

        public JSONObjectPutter() {
        }

        public JSONObjectPutter(JSONObject jsonObject) {
            this();
            this.jsonObject = jsonObject;
        }

        public void setJSONObject(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public void put(String key, Object value) throws JSONException {
            if (null == value || JSONObject.NULL.equals(value)) {
                return;
            }
            this.jsonObject.put(key, value);
        }
    }

    private static final class JSONArrayPutter
    implements JSONValuePutter {
        private JSONArray jsonArray;

        public JSONArrayPutter() {
        }

        public JSONArrayPutter(JSONArray jsonArray) {
            this();
            this.jsonArray = jsonArray;
        }

        public void setJSONArray(JSONArray jsonArray) {
            this.jsonArray = jsonArray;
        }

        @Override
        public void put(String key, Object value) throws JSONException {
            this.jsonArray.put(value);
        }
    }

    private static interface JSONValuePutter {
        public void put(String var1, Object var2) throws JSONException;
    }
}

