/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.SortOrder;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.ContactSearchMultiplexer;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.Utility;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.mapping.UserMapper;
import com.openexchange.user.json.services.ServiceRegistry;
import com.openexchange.user.json.writer.UserWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="search", description="Search users.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="The requested fields."), @Parameter(name="sort", optional=true, type=Type.NUMBER, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified. In case of use of column 609 (use count depending order for collected users with global address book) the parameter \"order\" ist NOT necessary and will be ignored."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, requestBody="An Object as described in Search users. Alternative request body: An Object as described in Search users alternative.", responseDescription="An array with user data. Each array element describes one user and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class SearchAction
extends AbstractUserAction {
    private static final Contact[] EMPTY_CONTACTS = new Contact[0];
    public static final String ACTION = "search";
    private static final Set<String> EXPECTED_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("columns", "sort", "order", "timezone", "session", "action")));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        UserField orderByUserField;
        ContactField sortField;
        int[] columns = SearchAction.parseIntArrayParameter("columns", request);
        int orderBy = SearchAction.parseIntParameter("sort", request);
        Order order = OrderFields.parse((String)request.getParameter("order"));
        String collation = request.getParameter("collation");
        JSONObject jData = (JSONObject)request.getData();
        ContactSearchObject contactSearch = new ContactSearchObject();
        contactSearch.addFolder(6);
        try {
            if (jData.has("pattern")) {
                contactSearch.setPattern(SearchAction.parseString(jData, "pattern"));
            }
            if (jData.has("startletter")) {
                contactSearch.setStartLetter(SearchAction.parseBoolean(jData, "startletter"));
            }
            if (jData.has("emailAutoComplete") && jData.getBoolean("emailAutoComplete")) {
                contactSearch.setEmailAutoComplete(true);
            }
            if (jData.has("orSearch") && jData.getBoolean("orSearch")) {
                contactSearch.setOrSearch(true);
            }
            contactSearch.setSurname(SearchAction.parseString(jData, "last_name"));
            contactSearch.setDisplayName(SearchAction.parseString(jData, "display_name"));
            contactSearch.setGivenName(SearchAction.parseString(jData, "first_name"));
            contactSearch.setCompany(SearchAction.parseString(jData, "company"));
            contactSearch.setEmail1(SearchAction.parseString(jData, "email1"));
            contactSearch.setEmail2(SearchAction.parseString(jData, "email2"));
            contactSearch.setEmail3(SearchAction.parseString(jData, "email3"));
            contactSearch.setDynamicSearchField(SearchAction.parseJSONIntArray(jData, "dynamicsearchfield"));
            contactSearch.setDynamicSearchFieldValue(SearchAction.parseJSONStringArray(jData, "dynamicsearchfieldvalue"));
            contactSearch.setPrivatePostalCodeRange(SearchAction.parseJSONStringArray(jData, "privatepostalcoderange"));
            contactSearch.setBusinessPostalCodeRange(SearchAction.parseJSONStringArray(jData, "businesspostalcoderange"));
            contactSearch.setPrivatePostalCodeRange(SearchAction.parseJSONStringArray(jData, "privatepostalcoderange"));
            contactSearch.setOtherPostalCodeRange(SearchAction.parseJSONStringArray(jData, "otherpostalcoderange"));
            contactSearch.setBirthdayRange(SearchAction.parseJSONDateArray(jData, "birthdayrange"));
            contactSearch.setAnniversaryRange(SearchAction.parseJSONDateArray(jData, "anniversaryrange"));
            contactSearch.setNumberOfEmployeesRange(SearchAction.parseJSONStringArray(jData, "numberofemployee"));
            contactSearch.setSalesVolumeRange(SearchAction.parseJSONStringArray(jData, "salesvolumerange"));
            contactSearch.setCreationDateRange(SearchAction.parseJSONDateArray(jData, "creationdaterange"));
            contactSearch.setLastModifiedRange(SearchAction.parseJSONDateArray(jData, "lastmodifiedrange"));
            contactSearch.setCatgories(SearchAction.parseString(jData, "categories"));
            contactSearch.setSubfolderSearch(SearchAction.parseBoolean(jData, "subfoldersearch"));
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        UserField orderField = (UserField)UserMapper.getInstance().getMappedField(orderBy);
        SortOptions sortOptions = new SortOptions(collation);
        if (null == orderField && null != (sortField = (ContactField)ContactMapper.getInstance().getMappedField(orderBy))) {
            sortOptions.setOrderBy(new SortOrder[]{SortOptions.Order((ContactField)sortField, (Order)order)});
        }
        Date lastModified = new Date(0L);
        ArrayList<UserContact> userContacts = new ArrayList<UserContact>();
        ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class);
        ContactField[] contactFields = (ContactField[])ContactMapper.getInstance().getFields(columns, (Enum[])new ContactField[]{ContactField.INTERNAL_USERID, ContactField.LAST_MODIFIED});
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        SearchIterator searchIterator = null;
        try {
            searchIterator = contactService.searchUsers((Session)session, contactSearch, contactFields, sortOptions);
            while (searchIterator.hasNext()) {
                Contact contact = (Contact)searchIterator.next();
                if (contact.getLastModified().after(lastModified)) {
                    lastModified = contact.getLastModified();
                }
                User user = userService.getUser(contact.getInternalUserId(), session.getContext());
                userContacts.add(new UserContact(contact, user));
            }
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        if (1 < userContacts.size() && null != (orderByUserField = (UserField)UserMapper.getInstance().getMappedField(orderBy))) {
            Collections.sort(userContacts, UserContact.getComparator(orderByUserField, session.getUser().getLocale(), Order.DESCENDING.equals((Object)order)));
        }
        return new AJAXRequestResult(userContacts, lastModified, "usercontact");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult performOLD(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            Contact[] contacts;
            SearchIterator it;
            int[] checkedCols;
            ContactSearchMultiplexer multiplexer;
            int[] columns = SearchAction.parseIntArrayParameter("columns", request);
            int orderBy = SearchAction.parseIntParameter("sort", request);
            Order order = OrderFields.parse((String)request.getParameter("order"));
            String collation = request.getParameter("collation");
            String timeZoneId = request.getParameter("timezone");
            Map<String, List<String>> attributeParameters = SearchAction.getAttributeParameters(EXPECTED_NAMES, request);
            JSONObject jData = (JSONObject)request.getData();
            ContactSearchObject searchObj = new ContactSearchObject();
            searchObj.addFolder(6);
            if (jData.has("pattern")) {
                searchObj.setPattern(SearchAction.parseString(jData, "pattern"));
            }
            if (jData.has("startletter")) {
                searchObj.setStartLetter(SearchAction.parseBoolean(jData, "startletter"));
            }
            if (jData.has("emailAutoComplete") && jData.getBoolean("emailAutoComplete")) {
                searchObj.setEmailAutoComplete(true);
            }
            if (jData.has("orSearch") && jData.getBoolean("orSearch")) {
                searchObj.setOrSearch(true);
            }
            searchObj.setSurname(SearchAction.parseString(jData, "last_name"));
            searchObj.setDisplayName(SearchAction.parseString(jData, "display_name"));
            searchObj.setGivenName(SearchAction.parseString(jData, "first_name"));
            searchObj.setCompany(SearchAction.parseString(jData, "company"));
            searchObj.setEmail1(SearchAction.parseString(jData, "email1"));
            searchObj.setEmail2(SearchAction.parseString(jData, "email2"));
            searchObj.setEmail3(SearchAction.parseString(jData, "email3"));
            searchObj.setDynamicSearchField(SearchAction.parseJSONIntArray(jData, "dynamicsearchfield"));
            searchObj.setDynamicSearchFieldValue(SearchAction.parseJSONStringArray(jData, "dynamicsearchfieldvalue"));
            searchObj.setPrivatePostalCodeRange(SearchAction.parseJSONStringArray(jData, "privatepostalcoderange"));
            searchObj.setBusinessPostalCodeRange(SearchAction.parseJSONStringArray(jData, "businesspostalcoderange"));
            searchObj.setPrivatePostalCodeRange(SearchAction.parseJSONStringArray(jData, "privatepostalcoderange"));
            searchObj.setOtherPostalCodeRange(SearchAction.parseJSONStringArray(jData, "otherpostalcoderange"));
            searchObj.setBirthdayRange(SearchAction.parseJSONDateArray(jData, "birthdayrange"));
            searchObj.setAnniversaryRange(SearchAction.parseJSONDateArray(jData, "anniversaryrange"));
            searchObj.setNumberOfEmployeesRange(SearchAction.parseJSONStringArray(jData, "numberofemployee"));
            searchObj.setSalesVolumeRange(SearchAction.parseJSONStringArray(jData, "salesvolumerange"));
            searchObj.setCreationDateRange(SearchAction.parseJSONDateArray(jData, "creationdaterange"));
            searchObj.setLastModifiedRange(SearchAction.parseJSONDateArray(jData, "lastmodifiedrange"));
            searchObj.setCatgories(SearchAction.parseString(jData, "categories"));
            searchObj.setSubfolderSearch(SearchAction.parseBoolean(jData, "subfoldersearch"));
            UserField sortField = UserField.getUserOnlyField(orderBy);
            if (null == sortField) {
                multiplexer = new ContactSearchMultiplexer((ContactInterfaceDiscoveryService)ServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class));
                checkedCols = Utility.checkForRequiredField(columns, UserField.INTERNAL_USERID.getColumn());
                it = multiplexer.extendedSearch(session, searchObj, orderBy, order, collation, checkedCols);
            } else {
                multiplexer = new ContactSearchMultiplexer((ContactInterfaceDiscoveryService)ServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class));
                checkedCols = Utility.checkForRequiredField(columns, UserField.INTERNAL_USERID.getColumn());
                it = multiplexer.extendedSearch(session, searchObj, UserField.DISPLAY_NAME.getColumn(), Order.ASCENDING, collation, checkedCols);
            }
            try {
                ArrayList<Object> list = new ArrayList<Object>(128);
                while (it.hasNext()) {
                    list.add(it.next());
                }
                contacts = list.toArray(EMPTY_CONTACTS);
            }
            finally {
                try {
                    it.close();
                }
                catch (Exception e) {
                    Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SearchAction.class));
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
            User[] users = new User[contacts.length];
            for (int i = 0; i < users.length; ++i) {
                users[i] = userService.getUser(contacts[i].getInternalUserId(), session.getContext());
            }
            Date lastModified = new Date(0L);
            for (int i = 1; i < contacts.length; ++i) {
                Date lm = contacts[i].getLastModified();
                if (!lastModified.before(lm)) continue;
                lastModified = lm;
            }
            SearchAction.censor(session, contacts);
            SearchAction.censor(session, users);
            JSONArray jsonArray = UserWriter.writeMultiple2Array(columns, attributeParameters, users, contacts, timeZoneId);
            return new AJAXRequestResult((Object)jsonArray, lastModified);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static String parseString(JSONObject jsonObj, String name) throws JSONException {
        String test;
        String retval = null;
        if (jsonObj.hasAndNotNull(name) && 0 != (test = jsonObj.getString(name)).length()) {
            retval = test;
        }
        return retval;
    }

    private static boolean parseBoolean(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.has(name)) {
            return false;
        }
        return jsonObj.getBoolean(name);
    }

    private static int[] parseJSONIntArray(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        if (tmp == null) {
            return null;
        }
        try {
            int[] i = new int[tmp.length()];
            for (int a = 0; a < tmp.length(); ++a) {
                i[a] = tmp.getInt(a);
            }
            return i;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create((Throwable)exc, new Object[]{name, tmp});
        }
    }

    private static String[] parseJSONStringArray(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.hasAndNotNull(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        String[] s = new String[tmp.length()];
        for (int a = 0; a < tmp.length(); ++a) {
            s[a] = tmp.getString(a);
        }
        return s;
    }

    private static Date[] parseJSONDateArray(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        if (tmp == null) {
            return null;
        }
        try {
            Date[] d = new Date[tmp.length()];
            for (int a = 0; a < tmp.length(); ++a) {
                d[a] = new Date(tmp.getLong(a));
            }
            return d;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create((Throwable)exc, new Object[]{name, tmp});
        }
    }
}

