/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.api2.ContactInterfaceFactory;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.SortOrder;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.Order;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.UserContact;
import com.openexchange.user.json.Utility;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.comparator.Comparators;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.mapping.UserMapper;
import com.openexchange.user.json.services.ServiceRegistry;
import com.openexchange.user.json.writer.UserWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.json.JSONArray;

@Action(method=RequestMethod.GET, name="all", description="Get all users.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for users are defined in Common object data, Detailed contact data and Detailed user data."), @Parameter(name="sort", optional=true, type=Type.NUMBER, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="Response with timestamp: An array with user data. Each array element describes one user and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class AllAction
extends AbstractUserAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AllAction.class));
    public static final String ACTION = "all";
    private static final Set<String> EXPECTED_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("columns", "sort", "order", "left_hand_limit", "right_hand_limit", "timezone", "session", "action")));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            ContactField orderByContactField;
            int[] columns = AllAction.parseIntArrayParameter("columns", request);
            int orderBy = AllAction.parseIntParameter("sort", request);
            Order order = OrderFields.parse((String)request.getParameter("order"));
            int leftHandLimit = AllAction.parseIntParameter("left_hand_limit", request);
            int rightHandLimit = AllAction.parseIntParameter("right_hand_limit", request);
            int lhl = leftHandLimit < 0 ? 0 : leftHandLimit;
            int rhl = rightHandLimit <= 0 ? 50000 : rightHandLimit;
            SortOptions sortOptions = new SortOptions(lhl, rhl - lhl);
            UserField orderByUserField = (UserField)UserMapper.getInstance().getMappedField(orderBy);
            if (null == orderByUserField && null != (orderByContactField = (ContactField)ContactMapper.getInstance().getMappedField(orderBy))) {
                sortOptions.setOrderBy(new SortOrder[]{SortOptions.Order((ContactField)orderByContactField, (Order)order)});
            }
            Date lastModified = new Date(0L);
            ArrayList<UserContact> userContacts = new ArrayList<UserContact>();
            ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class);
            ContactField[] contactFields = (ContactField[])ContactMapper.getInstance().getFields(columns, (Enum[])new ContactField[]{ContactField.INTERNAL_USERID, ContactField.LAST_MODIFIED});
            UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
            SearchIterator searchIterator = null;
            try {
                searchIterator = contactService.getAllUsers((Session)session, contactFields, sortOptions);
                while (searchIterator.hasNext()) {
                    Contact contact = (Contact)searchIterator.next();
                    if (contact.getLastModified().after(lastModified)) {
                        lastModified = contact.getLastModified();
                    }
                    User user = userService.getUser(contact.getInternalUserId(), session.getContext());
                    userContacts.add(new UserContact(contact, user));
                }
            }
            finally {
                if (null != searchIterator) {
                    searchIterator.close();
                }
            }
            if (1 < userContacts.size() && null != orderByUserField) {
                Collections.sort(userContacts, UserContact.getComparator(orderByUserField, session.getUser().getLocale(), Order.DESCENDING.equals((Object)order)));
            }
            return new AJAXRequestResult(userContacts, lastModified, "usercontact");
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AJAXRequestResult performOLD(AJAXRequestData request, ServerSession session) throws OXException {
        try {
            User[] users;
            Contact[] contacts;
            int[] columns = AllAction.parseIntArrayParameter("columns", request);
            int orderBy = AllAction.parseIntParameter("sort", request);
            Order order = OrderFields.parse((String)request.getParameter("order"));
            int leftHandLimit = AllAction.parseIntParameter("left_hand_limit", request);
            int rightHandLimit = AllAction.parseIntParameter("right_hand_limit", request);
            String timeZoneId = request.getParameter("timezone");
            Map<String, List<String>> attributeParameters = AllAction.getAttributeParameters(EXPECTED_NAMES, request);
            UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
            ContactInterface contactInterface = ((ContactInterfaceFactory)ServiceRegistry.getInstance().getService(ContactInterfaceFactory.class, true)).create(6, (Session)session);
            if (-1 != orderBy) {
                int rhl;
                UserField orderField = UserField.getUserOnlyField(orderBy);
                int[] checkedCols = Utility.checkForRequiredField(columns, UserField.INTERNAL_USERID.getColumn());
                if (null == orderField) {
                    int lhl = leftHandLimit < 0 ? 0 : leftHandLimit;
                    int rhl2 = rightHandLimit <= 0 ? 50000 : rightHandLimit;
                    SearchIterator it = contactInterface.getContactsInFolder(6, lhl, rhl2, orderBy, order, null, checkedCols);
                    try {
                        ArrayList<Object> contactList = new ArrayList<Object>(128);
                        while (it.hasNext()) {
                            contactList.add(it.next());
                        }
                        contacts = contactList.toArray(new Contact[contactList.size()]);
                        users = new User[contacts.length];
                        for (int j = 0; j < users.length; ++j) {
                            int userId = contacts[j].getInternalUserId();
                            if (userId > 0) {
                                users[j] = userService.getUser(userId, session.getContext());
                                continue;
                            }
                            LOG.error((Object)("Missing internal user ID in contact " + contacts[j].getObjectID() + ": " + contacts[j].getDisplayName()));
                        }
                    }
                    finally {
                        try {
                            it.close();
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                ArrayList<User> allUsers = new ArrayList<User>();
                for (User user : userService.getUser(session.getContext())) {
                    allUsers.add(user);
                }
                Collections.sort(allUsers, Comparators.getComparator(orderField, session.getUser().getLocale(), Order.DESCENDING.equals((Object)order)));
                int lhl = leftHandLimit < 0 ? 0 : leftHandLimit;
                int n = rhl = rightHandLimit <= 0 ? 50000 : rightHandLimit;
                if (rhl - lhl >= allUsers.size()) {
                    rhl = allUsers.size();
                }
                users = allUsers.subList(lhl, rhl).toArray(new User[rhl - lhl]);
                int[] userIds = new int[users.length];
                for (int i = 0; i < users.length; ++i) {
                    userIds[i] = users[i].getId();
                }
                contacts = contactInterface.getUsersById(userIds, false);
            } else {
                int rhl;
                ArrayList<User> allUsers = new ArrayList<User>();
                for (User user : userService.getUser(session.getContext())) {
                    allUsers.add(user);
                }
                int lhl = leftHandLimit < 0 ? 0 : leftHandLimit;
                int n = rhl = rightHandLimit <= 0 ? 50000 : rightHandLimit;
                if (rhl - lhl >= allUsers.size()) {
                    rhl = allUsers.size();
                }
                users = allUsers.subList(lhl, rhl).toArray(new User[rhl - lhl]);
                int[] userIds = new int[users.length];
                for (int i = 0; i < users.length; ++i) {
                    userIds[i] = users[i].getId();
                }
                contacts = contactInterface.getUsersById(userIds, false);
            }
            Date lastModified = contacts[0].getLastModified();
            for (int i = 1; i < contacts.length; ++i) {
                Date lm = contacts[i].getLastModified();
                if (!lastModified.before(lm)) continue;
                lastModified = lm;
            }
            AllAction.censor(session, contacts);
            AllAction.censor(session, users);
            JSONArray jsonArray = UserWriter.writeMultiple2Array(columns, attributeParameters, users, contacts, timeZoneId);
            return new AJAXRequestResult((Object)jsonArray, lastModified);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }
}

