/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class CountingInputStream
extends FilterInputStream {
    private final AtomicLong count;
    private volatile long mark;
    private volatile long max;

    public CountingInputStream(InputStream in, long max) {
        super(in);
        this.max = max;
        this.count = new AtomicLong(0L);
        this.mark = -1L;
    }

    public long resetByteCount() {
        long tmp = this.count.get();
        this.count.set(0L);
        return tmp;
    }

    public long getCount() {
        return this.count.get();
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        long max = this.max;
        if (this.count.addAndGet((long)result >= 0L ? (long)result : 0L) > max) {
            throw new IOException("Max. byte count of " + max + " exceeded.");
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        long max = this.max;
        if (this.count.addAndGet((long)result >= 0L ? (long)result : 0L) > max) {
            throw new IOException("Max. byte count of " + max + " exceeded.");
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        long max = this.max;
        if (this.count.addAndGet((long)result >= 0L ? (long)result : 0L) > max) {
            throw new IOException("Max. byte count of " + max + " exceeded.");
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.max += n;
        this.count.addAndGet(result);
        return result;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count.get();
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        long mark = this.mark;
        if (mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count.set(mark);
    }
}

