/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Databases {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf(LogFactory.getLog(Databases.class));
    public static final int IN_LIMIT = 1000;
    private static final Pattern PAT_TRUNCATED_IDS = Pattern.compile("([^']*')(\\S+)('[^']*)");

    private Databases() {
    }

    public static void closeSQLStuff(ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void closeSQLStuff(Statement stmt) {
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void closeSQLStuff(ResultSet result, Statement stmt) {
        Databases.closeSQLStuff(result);
        Databases.closeSQLStuff(stmt);
    }

    public static String getStatement(Statement stmt) {
        return stmt == null ? "" : stmt.toString();
    }

    public static String getStatement(PreparedStatement stmt, String query) {
        if (stmt == null) {
            return query;
        }
        try {
            return stmt.toString();
        }
        catch (Exception x) {
            return query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTransaction(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            con.setAutoCommit(false);
            stmt = con.createStatement();
            stmt.execute("START TRANSACTION");
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(stmt);
            throw throwable;
        }
        Databases.closeSQLStuff(stmt);
    }

    public static void rollback(Connection con) {
        if (null == con) {
            return;
        }
        try {
            if (!con.isClosed()) {
                con.rollback();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void autocommit(Connection con) {
        if (null == con) {
            return;
        }
        try {
            if (!con.isClosed()) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String[] parseTruncatedFields(DataTruncation trunc) {
        Matcher matcher = PAT_TRUNCATED_IDS.matcher(trunc.getMessage());
        ArrayList<String> retval = new ArrayList<String>();
        if (matcher.find()) {
            for (int i = 2; i < matcher.groupCount(); ++i) {
                retval.add(matcher.group(i));
            }
        }
        return retval.toArray(new String[retval.size()]);
    }

    public static String getIN(String sql, int length) {
        StringBuilder retval = new StringBuilder(sql);
        for (int i = 0; i < length; ++i) {
            retval.append("?,");
        }
        retval.setCharAt(retval.length() - 1, ')');
        return retval.toString();
    }

    public static int getColumnSize(Connection con, String table, String column) throws SQLException {
        DatabaseMetaData metas = con.getMetaData();
        ResultSet result = metas.getColumns(null, null, table, column);
        int retval = -1;
        if (result.next()) {
            retval = result.getInt("COLUMN_SIZE");
        }
        return retval;
    }

    public static Set<String> existingTables(Connection con, String ... tablesToCheck) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        for (String table : tablesToCheck) {
            if (!Databases.tableExists(con, table)) continue;
            tables.add(table);
        }
        return tables;
    }

    public static boolean tablesExist(Connection con, String ... tablesToCheck) throws SQLException {
        for (String table : tablesToCheck) {
            if (Databases.tableExists(con, table)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{"TABLE"});
            retval = rs.next() && rs.getString("TABLE_NAME").equals(table);
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs);
            throw throwable;
        }
        Databases.closeSQLStuff(rs);
        return retval;
    }
}

