/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.datatypes.genericonf;

import com.openexchange.datatypes.genericonf.WidgetSwitcher;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class FormElement {
    private String name;
    private String displayName;
    private Widget widget;
    private String customWidget;
    private Object defaultValue;
    private boolean mandatory;
    private final Map<String, String> options = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public String getCustomWidget() {
        return this.customWidget;
    }

    public void setCustomWidget(String customWidget) {
        this.customWidget = customWidget;
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public FormElement setOption(String optionName, String value) {
        this.options.put(optionName, value);
        return this;
    }

    public FormElement removeOption(String optionName) {
        this.options.remove(optionName);
        return this;
    }

    public FormElement clearOptions() {
        this.options.clear();
        return this;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String toString() {
        return this.name;
    }

    public static FormElement formElement(String name, String displayName, boolean mandatory, Object defaultValue) {
        FormElement formElement = new FormElement();
        formElement.setName(name);
        formElement.setDisplayName(displayName);
        formElement.setMandatory(mandatory);
        formElement.setDefaultValue(defaultValue);
        return formElement;
    }

    public static FormElement input(String name, String displayName, boolean mandatory, String defaultValue) {
        FormElement formElement = FormElement.formElement(name, displayName, mandatory, defaultValue);
        formElement.setWidget(Widget.INPUT);
        return formElement;
    }

    public static FormElement input(String name, String displayName) {
        return FormElement.input(name, displayName, true, null);
    }

    public static FormElement password(String name, String displayName, boolean mandatory, String defaultValue) {
        FormElement formElement = FormElement.formElement(name, displayName, mandatory, defaultValue);
        formElement.setWidget(Widget.PASSWORD);
        return formElement;
    }

    public static FormElement link(String name, String displayName, boolean mandatory, Boolean defaultValue) {
        FormElement formElement = FormElement.formElement(name, displayName, mandatory, defaultValue);
        formElement.setWidget(Widget.LINK);
        return formElement;
    }

    public static FormElement link(String name, String displayName) {
        return FormElement.link(name, displayName, true, null);
    }

    public static FormElement password(String name, String displayName) {
        return FormElement.password(name, displayName, true, null);
    }

    public static FormElement text(String name, String displayName, boolean mandatory, Boolean defaultValue) {
        FormElement formElement = FormElement.formElement(name, displayName, mandatory, defaultValue);
        formElement.setWidget(Widget.TEXT);
        return formElement;
    }

    public static FormElement text(String name, String displayName) {
        return FormElement.text(name, displayName, true, null);
    }

    public static FormElement checkbox(String name, String displayName, boolean mandatory, Boolean defaultValue) {
        FormElement formElement = FormElement.formElement(name, displayName, mandatory, defaultValue);
        formElement.setWidget(Widget.CHECKBOX);
        return formElement;
    }

    public static FormElement checkbox(String name, String displayName) {
        return FormElement.checkbox(name, displayName, true, null);
    }

    public static FormElement custom(String widget, String name, String displayName, boolean mandatory, String defaultValue) {
        FormElement formElement = FormElement.formElement(name, displayName, mandatory, defaultValue);
        formElement.setWidget(Widget.CUSTOM);
        formElement.setCustomWidget(widget);
        return formElement;
    }

    public static FormElement custom(String widget, String name, String displayName) {
        return FormElement.custom(widget, name, displayName, true, null);
    }

    public Object doSwitch(WidgetSwitcher switcher, Object ... args) {
        return this.widget.doSwitch(switcher, args);
    }

    public static enum Widget {
        INPUT("input"),
        PASSWORD("password"),
        CHECKBOX("checkbox"),
        LINK("link"),
        TEXT("text"),
        CUSTOM("custom");

        private final String keyword;

        private Widget(String keyword) {
            this.keyword = keyword;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public Object doSwitch(WidgetSwitcher switcher, Object ... args) {
            switch (this) {
                case INPUT: {
                    return switcher.input(args);
                }
                case PASSWORD: {
                    return switcher.password(args);
                }
                case CHECKBOX: {
                    return switcher.checkbox(args);
                }
                case LINK: {
                    return switcher.link(args);
                }
                case TEXT: {
                    return switcher.text(args);
                }
                case CUSTOM: {
                    return switcher.custom(args);
                }
            }
            throw new IllegalArgumentException("Didn't understand " + this.getKeyword());
        }

        public static Widget getWidgetByKeyword(String keyword) {
            for (Widget widget : Widget.values()) {
                if (!widget.getKeyword().equals(keyword)) continue;
                return widget;
            }
            return null;
        }

        public static Widget chooseFromHTMLElement(Element inputElement) {
            if ("input".equalsIgnoreCase(inputElement.getTagName())) {
                String type = inputElement.getAttribute("type");
                if ("text".equalsIgnoreCase(type)) {
                    return INPUT;
                }
                if ("password".equalsIgnoreCase(type)) {
                    return PASSWORD;
                }
                if ("checkbox".equalsIgnoreCase(type)) {
                    return CHECKBOX;
                }
            }
            return null;
        }
    }
}

