/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.l10n;

import java.util.Locale;

public enum SuperCollator {
    PRC_1("PRC", Locale.PRC, "gb2312", "gb2312_chinese_ci"),
    PRC_2("PRC", Locale.PRC, "gbk", "gbk_chinese_ci"),
    CHINA_TAIWAN("TAIWAN", Locale.TAIWAN, "big5", "big5_chinese_ci"),
    CHINA_2("CHINESE", Locale.CHINESE, "gb2312", "gb2312_chinese_ci"),
    CHINA_3("CHINA", Locale.CHINA, "gb2312", "gb2312_chinese_ci"),
    DEFAULT("DEFAULT", Locale.getDefault(), "utf8", "utf8_general_ci");

    private String collation;
    private String sqlCharset;
    private Locale locale;
    private String name;

    public String getSqlCollation() {
        return this.collation;
    }

    public String getSqlCharset() {
        return this.sqlCharset;
    }

    public Locale getJavaLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    private SuperCollator(String name, Locale local, String sqlCharset, String collation) {
        this.name = name;
        this.locale = local;
        this.sqlCharset = sqlCharset;
        this.collation = collation;
    }

    public static SuperCollator get(String something) {
        SuperCollator result = null;
        result = SuperCollator.getBySqlCollation(something);
        if (result != null) {
            return result;
        }
        result = SuperCollator.getBySqlCharset(something);
        if (result != null) {
            return result;
        }
        result = SuperCollator.getByJavaLocale(something);
        if (result != null) {
            return result;
        }
        result = SuperCollator.getByName(something);
        if (result != null) {
            return result;
        }
        return result;
    }

    public static SuperCollator getByJavaLocale(String something) {
        Locale javaLocale;
        if (something == null) {
            return null;
        }
        String[] parts = something.split("_");
        String lang = null;
        String country = null;
        String variant = null;
        if (parts.length > 0) {
            lang = parts[0];
        }
        if (parts.length > 1) {
            country = parts[1];
        }
        if (parts.length > 2) {
            variant = parts[2];
        }
        for (SuperCollator loc : SuperCollator.values()) {
            javaLocale = loc.getJavaLocale();
            if (!javaLocale.getVariant().equalsIgnoreCase(variant) || !javaLocale.getCountry().equalsIgnoreCase(country) || !javaLocale.getLanguage().equalsIgnoreCase(lang)) continue;
            return loc;
        }
        for (SuperCollator loc : SuperCollator.values()) {
            javaLocale = loc.getJavaLocale();
            if (!javaLocale.getCountry().equalsIgnoreCase(country) || !javaLocale.getLanguage().equalsIgnoreCase(lang)) continue;
            return loc;
        }
        for (SuperCollator loc : SuperCollator.values()) {
            javaLocale = loc.getJavaLocale();
            if (!javaLocale.getLanguage().equalsIgnoreCase(lang)) continue;
            return loc;
        }
        return null;
    }

    public static SuperCollator getBySqlCollation(String something) {
        for (SuperCollator loc : SuperCollator.values()) {
            if (!loc.getSqlCollation().equalsIgnoreCase(something)) continue;
            return loc;
        }
        return null;
    }

    public static SuperCollator getBySqlCharset(String something) {
        for (SuperCollator loc : SuperCollator.values()) {
            if (!loc.getSqlCharset().equalsIgnoreCase(something)) continue;
            return loc;
        }
        return null;
    }

    public static SuperCollator getByName(String something) {
        for (SuperCollator loc : SuperCollator.values()) {
            if (!loc.getName().equalsIgnoreCase(something)) continue;
            return loc;
        }
        return null;
    }
}

