/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.PathResolver;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.paths.impl.PathResolverImpl;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.InfostoreWebdavFactory;
import com.openexchange.groupware.infostore.webdav.PropertyStore;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.test.TestInit;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.DummySessionHolder;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.impl.DummyResourceManager;

public class TestWebdavFactoryBuilder {
    public static final int DUMMY = 0;
    public static final int INFO = 1;
    private static final int mode = 1;

    public static WebdavFactory buildFactory() throws Exception {
        switch (1) {
            case 0: {
                return TestWebdavFactoryBuilder.buildDummyFactory();
            }
            case 1: {
                return TestWebdavFactoryBuilder.buildInfoFactory();
            }
        }
        return null;
    }

    private static WebdavFactory buildDummyFactory() {
        return DummyResourceManager.getInstance();
    }

    private static WebdavFactory buildInfoFactory() throws Exception {
        InfostoreWebdavFactory factory = new InfostoreWebdavFactory();
        InfostoreFacadeImpl database = new InfostoreFacadeImpl();
        factory.setDatabase((InfostoreFacade)database);
        factory.setSecurity(database.getSecurity());
        factory.setFolderLockManager((FolderLockManager)new FolderLockManagerImpl());
        factory.setFolderProperties((PropertyStore)new PropertyStoreImpl("oxfolder_property"));
        factory.setInfoLockManager((EntityLockManager)new EntityLockManagerImpl("infostore_lock"));
        factory.setLockNullLockManager((EntityLockManager)new EntityLockManagerImpl("lock_null_lock"));
        factory.setInfoProperties((PropertyStore)new PropertyStoreImpl("infostore_property"));
        factory.setProvider((DBProvider)new DBPoolProvider());
        factory.setResolver((PathResolver)new PathResolverImpl(factory.getDatabase()));
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        Context ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        factory.setSessionHolder((SessionHolder)new DummySessionHolder(TestWebdavFactoryBuilder.getUsername(), ctx));
        return factory;
    }

    private static String getUsername() {
        String un = AjaxInit.getAJAXProperty("login");
        int pos = un.indexOf(64);
        return pos == -1 ? un : un.substring(0, pos);
    }

    public static void setUp() throws Exception {
        TestInit.loadTestProperties();
        Init.startServer();
    }

    public static void tearDown() throws Exception {
        Init.stopServer();
    }
}

