/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.client;

import com.openexchange.webdav.WebdavClientTest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Random;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class NaughtyClientTest
extends WebdavClientTest {
    public void testContentLengthTooLarge() throws Exception {
        this.contentLengthTest(20, 30);
    }

    public void contentLengthTest(int size, final int pretendSize) throws MalformedURLException, IOException, InterruptedException {
        final byte[] data = new byte[size];
        Random r = new Random();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)r.nextInt();
        }
        HttpURL url = new HttpURL(this.getUrl("testFile.bin"));
        PutMethod put = new PutMethod(url.getEscapedURI());
        put.getHostAuthState().setAuthScheme((AuthScheme)new BasicScheme());
        put.setRequestEntity(new RequestEntity(){

            public long getContentLength() {
                return pretendSize;
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                out.write(data);
            }
        });
        HttpClient client = new HttpClient();
        this.setAuth(client);
        try {
            client.executeMethod((HttpMethod)put);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.clean.add("testFile.bin");
        GetMethod get = new GetMethod(url.getEscapedURI());
        int i = 0;
        do {
            Thread.sleep(100L);
            get = new GetMethod(url.getEscapedURI());
            client.executeMethod((HttpMethod)get);
        } while (++i < 10 && get.getStatusCode() != 200);
        NaughtyClientTest.assertEquals((int)200, (int)get.getStatusCode());
        NaughtyClientTest.assertEquals((String)String.valueOf(size), (String)get.getResponseHeader("content-length").getValue());
        this.assertEqualContent(get.getResponseBodyAsStream(), new ByteArrayInputStream(data));
    }
}

