/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sms;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.TestServiceRegistry;
import com.openexchange.sms.PhoneNumberParserService;
import java.util.Locale;
import junit.framework.TestCase;

public class PhoneNumberParserServiceTest
extends TestCase {
    private final String EXPECTED = "491234567890";
    private final String[] TO_PARSE = new String[]{"00491234567890", "01234567890", "+491234567890", "004901234567890", "+4901234567890", "0049 123 4567890", "0123/4567890"};

    public void testParsePhoneNumbers() throws Exception {
        PhoneNumberParserService service = TestServiceRegistry.getInstance().getService(PhoneNumberParserService.class);
        for (String number : this.TO_PARSE) {
            String parsed = service.parsePhoneNumber(number, Locale.GERMANY);
            PhoneNumberParserServiceTest.assertEquals((String)("Could not parse " + number), (String)"491234567890", (String)parsed);
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        Init.startServer();
    }

    public void tearDown() throws Exception {
        Init.stopServer();
        super.tearDown();
    }
}

