/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.java.Charsets;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.messagestorage.MessageStorageTest;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.JsonMessageHandler;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public final class MailAttachmentTest
extends MessageStorageTest {
    private static final String RFC822_WITH_ATTACH = "Return-Path: <thorben.betten@open-xchange.com>\nReceived: from ox.netline-is.de ([unix socket])\n\tby ox (Cyrus v2.2.3) with LMTP; Fri, 04 Apr 2008 00:12:36 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid B0F553DBA6F; Fri,  4 Apr 2008 00:12:36 +0200 (CEST)\nReceived: from oxee (unknown [192.168.32.9])\n\tby ox.netline-is.de (Postfix) with ESMTP id 3C1C33DBA58\n\tfor <thorben.betten@open-xchange.com>; Fri,  4 Apr 2008 00:12:36 +0200 (CEST)\nDate: Fri, 4 Apr 2008 00:11:46 +0200 (CEST)\nFrom: \"Betten, Thorben\" <thorben.betten@open-xchange.com>\nTo: \"Betten, Thorben\" <thorben.betten@open-xchange.com>\nMessage-ID: <22037327.8941207260706888.JavaMail.open-xchange@oxee>\nSubject: DowngradeRegistry-Patch\nMIME-Version: 1.0\nContent-Type: multipart/mixed; \n\tboundary=\"----=_Part_582_17246096.1207260706746\"\nX-Priority: 3\nX-Mailer: Open-Xchange Mailer v6.5.0-6342\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\nX-Spam-Level: \nX-Spam-Status: No, hits=-4.6 required=5.0 tests=AWL,BAYES_00,HTML_MESSAGE \n\tautolearn=no version=2.64\n\n------=_Part_582_17246096.1207260706746\nContent-Type: multipart/alternative; \n\tboundary=\"----=_Part_583_11954091.1207260706746\"\n\n------=_Part_583_11954091.1207260706746\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n\n(see attached file)\n\n\n--\nwith best regards,\nThorben Betten\n\n_______________________________________________\nThorben Betten, Software Developer\nPhone +49 2761 8385 16\nFax +49 2761 8385 30\nOpen-Xchange GmbH, Martinstr. 41, D-57462 Olpe\n_______________________________________________\n------=_Part_583_11954091.1207260706746\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\">\n    <meta name=\"generator\"\n    content=\"HTML Tidy for Java (vers. 26 Sep 2004), see www.w3.org\" />\n\n    <title></title>\n  </head>\n\n  <body>\n    <br />\n    (see attached file)<br />\n\n    <div>\n      <br />\n      <br />\n      --<br />\n      with best regards,<br />\n      Thorben Betten<br />\n      <br />\n      _______________________________________________<br />\n      Thorben Betten, Software Developer<br />\n      Phone +49 2761 8385 16<br />\n      Fax +49 2761 8385 30<br />\n      Open-Xchange GmbH, Martinstr. 41, D-57462 Olpe<br />\n      _______________________________________________\n    </div>\n  </body>\n\n</html>\n\n------=_Part_583_11954091.1207260706746--\n\n------=_Part_582_17246096.1207260706746\nContent-Type: text/x-patch; charset=US-ASCII; \n\tname=downgrade_registry_patch.diff\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment; filename=downgrade_registry_patch.diff\n\nSW5kZXg6IHNyYy9jb20vb3BlbmV4Y2hhbmdlL2dyb3Vwd2FyZS9kb3duZ3JhZGUvRG93bmdyYWRl\nUmVnaXN0cnkuamF2YQo9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09\nPT09PT09PT09PT09PT09PT09PT09PT09ClJDUyBmaWxlOiAvY3Zzcm9vdC9vcGVuLXhjaGFuZ2Uv\nc2VydmVyL3NyYy9jb20vb3BlbmV4Y2hhbmdlL2dyb3Vwd2FyZS9kb3duZ3JhZGUvRG93bmdyYWRl\nUmVnaXN0cnkuamF2YSx2CnJldHJpZXZpbmcgcmV2aXNpb24gMS40CmRpZmYgLXUgLXIxLjQgRG93\nbmdyYWRlUmVnaXN0cnkuamF2YQotLS0gc3JjL2NvbS9vcGVuZXhjaGFuZ2UvZ3JvdXB3YXJlL2Rv\nd25ncmFkZS9Eb3duZ3JhZGVSZWdpc3RyeS5qYXZhCTEgQXByIDIwMDggMDk6MzQ6NDMgLTAwMDAJ\nMS40CisrKyBzcmMvY29tL29wZW5leGNoYW5nZS9ncm91cHdhcmUvZG93bmdyYWRlL0Rvd25ncmFk\nZVJlZ2lzdHJ5LmphdmEJMyBBcHIgMjAwOCAyMTozNDowNCAtMDAwMApAQCAtMjg4LDggKzI4OCwy\nNCBAQAogCXB1YmxpYyB2b2lkIHVucmVnaXN0ZXJEb3duZ3JhZGVMaXN0ZW5lcihmaW5hbCBEb3du\nZ3JhZGVMaXN0ZW5lciBsaXN0ZW5lcikgewogCQlyZWdpc3RyeUxvY2subG9jaygpOwogCQl0cnkg\newotCQkJbGlzdGVuZXJzLnJlbW92ZShsaXN0ZW5lcik7Ci0JCQljbGFzc2VzLnJlbW92ZShsaXN0\nZW5lci5nZXRDbGFzcygpKTsKKwkJCWZpbmFsIENsYXNzPD8gZXh0ZW5kcyBEb3duZ3JhZGVMaXN0\nZW5lcj4gY2xhenogPSBsaXN0ZW5lci5nZXRDbGFzcygpOworCQkJaWYgKCFjbGFzc2VzLmNvbnRh\naW5zKGNsYXp6KSkgeworCQkJCXJldHVybjsKKwkJCX0KKwkJCWlmICghbGlzdGVuZXJzLnJlbW92\nZShsaXN0ZW5lcikpIHsKKwkJCQkvKgorCQkJCSAqIFJlbW92ZSBieSByZWZlcmVuY2UgZGlkIG5v\ndCB3b3JrCisJCQkJICovCisJCQkJaW50IHNpemUgPSBsaXN0ZW5lcnMuc2l6ZSgpOworCQkJCWZv\nciAoaW50IGkgPSAwOyBpIDwgc2l6ZTsgaSsrKSB7CisJCQkJCWlmIChjbGF6ei5lcXVhbHMobGlz\ndGVuZXJzLmdldChpKS5nZXRDbGFzcygpKSkgeworCQkJCQkJbGlzdGVuZXJzLnJlbW92ZShpKTsK\nKwkJCQkJCS8vIFJlc2V0IHNpemUgdG8gbGVhdmUgbG9vcAorCQkJCQkJc2l6ZSA9IDA7CisJCQkJ\nCX0KKwkJCQl9CisJCQl9CisJCQljbGFzc2VzLnJlbW92ZShjbGF6eik7CiAJCX0gZmluYWxseSB7\nCiAJCQlyZWdpc3RyeUxvY2sudW5sb2NrKCk7CiAJCX0K\n------=_Part_582_17246096.1207260706746--\n";
    private static final String RFC822_WO_ATTACH = "Return-Path: <markus.strotkemper@open-xchange.com>\nReceived: from ox.netline-is.de ([unix socket])\n\tby ox (Cyrus v2.2.3) with LMTP; Fri, 04 Apr 2008 11:37:57 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid E44443DBC7F; Fri,  4 Apr 2008 11:37:56 +0200 (CEST)\nReceived: from netline.de (comfire.netline.de [192.168.32.1])\n\tby ox.netline-is.de (Postfix) with ESMTP id 250743DBC7D\n\tfor <thorben@open-xchange.com>; Fri,  4 Apr 2008 11:37:56 +0200 (CEST)\nReceived: from [10.20.30.11] (helo=www.open-xchange.org ident=mail)\n\tby netline.de with esmtp (Exim)\n\tid 1JhiCw-000368-00\n\tfor thorben@open-xchange.com; Fri, 04 Apr 2008 11:27:38 +0200\nReceived: from mail.open-xchange.com ([10.20.30.22] helo=ox.open-xchange.com)\n\tby www.open-xchange.org with esmtp (Exim 3.36 #1 (Debian))\n\tid 1JhiM6-0006Dp-00\n\tfor <thorben@open-xchange.org>; Fri, 04 Apr 2008 11:37:06 +0200\nReceived: by ox.open-xchange.com (Postfix, from userid 76)\n\tid C232532CDFA; Fri,  4 Apr 2008 11:37:05 +0200 (CEST)\nReceived: from ox.open-xchange.com ([unix socket])\n\t by ox.open-xchange.com (Cyrus v2.2.12-Invoca-RPM-2.2.12-8.1.RHEL4) with LMTPA;\n\t Fri, 04 Apr 2008 11:37:05 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.open-xchange.com (Postfix, from userid 99)\n\tid 7FEAA32CE1A; Fri,  4 Apr 2008 11:37:05 +0200 (CEST)\nReceived: from oxee (unknown [192.168.32.9])\n\tby ox.open-xchange.com (Postfix) with ESMTP id 4BF3832CD76\n\tfor <thorben.betten@open-xchange.com>; Fri,  4 Apr 2008 11:37:04 +0200 (CEST)\nDate: Fri, 4 Apr 2008 11:37:04 +0200 (CEST)\nFrom: \"Strotkemper, Markus\" <markus.strotkemper@open-xchange.com>\nTo: \"Betten, Thorben\" <thorben.betten@open-xchange.com>\nMessage-ID: <3231881.9631207301824285.JavaMail.open-xchange@oxee>\nIn-Reply-To: <30694952.9571207301412448.JavaMail.open-xchange@oxee>\nReferences: <23142826.9271207296337478.JavaMail.open-xchange@oxee> <30694952.9571207301412448.JavaMail.open-xchange@oxee>\nSubject: Re: port 2144\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: quoted-printable\nX-Priority: 3\nX-Mailer: Open-Xchange Mailer v6.5.0-6342\nX-Scanner: exiscan *1JhiCw-000368-00*GURR6OLwjOM* http://duncanthrax.net/exiscan/\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\nX-Spam-Level: \nX-Spam-Status: No, hits=-4.8 required=5.0 tests=AWL,BAYES_00 autolearn=ham \n\tversion=2.64\n\nDu, das geht bei mir auch net. Die scheinen den wieder deaktiviert zu haben=\n....\n\n\n\n\n\"Betten, Thorben\" <thorben.betten@open-xchange.com> hat am 4. April 2008 um=\n 11:30 geschrieben:\n\n> Hmm...\n>=20\n> funzt leider immer noch nicht:\n>=20\n> thorben@thorben:~$ telnet ns0.ovh.net 2144\n> Trying 213.186.33.20...\n>=20\n> Kommt leider kein Connect zustande...\n>=20\n> \"Strotkemper, Markus\" <markus.strotkemper@open-xchange.com> hat am 4. Apr=\nil\n> 2008 um 10:05 geschrieben:\n>=20\n> > Hi,\n> >=20\n> > hab Dir Port TCP2144 nach au=C3=9Fen freigegeben. Falls Daniel fragt: w=\nozu ist\n> > der? Und kannst Du mir bitte bescheit geben wenn Du ihn nicht mehr\n> > ben=C3=B6tigst?\n> >=20\n> > Besten Dank,\n> > Markus\n>=20\n>=20\n>=20\n>=20\n> --\n> with best regards,\n> Thorben Betten\n>=20\n> _______________________________________________\n> Thorben Betten, Software Developer\n> Phone +49 2761 8385 16\n> Fax +49 2761 8385 30\n> Open-Xchange GmbH, Martinstr. 41, D-57462 Olpe\n> _______________________________________________\n";
    private static final String RFC2231 = "From: Marcus Klein <m.klein@open-xchange.com>\nOrganization: Netline Internet Service GmbH\nX-KMail-Fcc: sent-mail\nTo: marcus@1337\nDate: Wed, 9 Jan 2008 11:01:10 +0100\nUser-Agent: KMail/1.9.7\nMIME-Version: 1.0\nContent-Type: Multipart/Mixed;\n  boundary=\"Boundary-00=_mtJhHd7H54sG6XG\"\nX-KMail-Recipients: marcus@1337\nStatus: R\nSubject: RFC2231-Test\nX-Status: N\nX-KMail-EncryptionState:  \nX-KMail-SignatureState:  \nX-KMail-MDN-Sent:  \nX-Length: 1307\nX-UID: 6\n\n--Boundary-00=_mtJhHd7H54sG6XG\nContent-Type: text/plain;\n  charset=\"utf-8\"\nContent-Transfer-Encoding: 7bit\nContent-Disposition: inline\n\n\n-- \nMarcus Klein\n--\nNetline Internet Service GmbH\n\nThere are 10 kinds of humans - those, who understand the\nbinary system, and those, who do not understand it.\n\n--Boundary-00=_mtJhHd7H54sG6XG\nContent-Type: text/plain;\n  charset=\"utf-8\";\n  name*=utf-8''test%20%C3%A4%C3%B6%C3%BC%2Etxt\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n\tfilename*=utf-8''test%20%C3%A4%C3%B6%C3%BC%2Etxt\n\ndGVzdMOkw7bDvAo=\n\n--Boundary-00=_mtJhHd7H54sG6XG\nContent-Type: text/plain; charset=\"utf-8\"; name*1*=utf-8''%EC%84%9C%EC%98%81%EC%A7%84; name*2*=funny%2Etxt\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n\tfilename*=utf-8''%EC%84%9C%EC%98%81%EC%A7%84%2Etxt\n\n7ISc7JiB7KeE\n\n--Boundary-00=_mtJhHd7H54sG6XG--\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailAttachment() {
        try {
            MailAccess<?, ?> mailAccess = this.getMailAccess();
            MailMessage[] mails = MailAttachmentTest.getMessages(this.getTestMailDir(), -1);
            String[] uids = mailAccess.getMessageStorage().appendMessages("INBOX", mails);
            try {
                MailMessage[] fetchedMails = mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID);
                for (int i = 0; i < fetchedMails.length; ++i) {
                    MailAttachmentTest.assertFalse((String)"Mail ID is null", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                }
                HashSet<String> hasAttachmentSet = new HashSet<String>(uids.length);
                fetchedMails = mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_MORE);
                for (int i = 0; i < fetchedMails.length; ++i) {
                    MailAttachmentTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailAttachmentTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailAttachmentTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                        MailAttachmentTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                    } else {
                        MailAttachmentTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
                    }
                    if (!fetchedMails[i].hasAttachment()) continue;
                    hasAttachmentSet.add(fetchedMails[i].getMailId());
                }
                for (String id : hasAttachmentSet) {
                    MailMessage mail = mailAccess.getMessageStorage().getMessage("INBOX", id, true);
                    MailPath mailPath = new MailPath(mailAccess.getAccountId(), mail.getFolder(), mail.getMailId());
                    SessionObject session = this.getSession();
                    JsonMessageHandler messageHandler = new JsonMessageHandler(0, mailPath, mail, DisplayMode.DISPLAY, false, (Session)session, UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId()), false, -1);
                    new MailMessageParser().parseMailMessage(mail, (MailMessageHandler)messageHandler);
                    JSONObject jObject = messageHandler.getJSONObject();
                    if (jObject.has(MailJSONField.ATTACHMENTS.getKey())) {
                        JSONArray jArray = jObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
                        int len = jArray.length();
                        MailAttachmentTest.assertTrue((String)"Missing attachments although existence indicated through 'hasAttachments()'", (len > 0 ? 1 : 0) != 0);
                        for (int i = 0; i < len; ++i) {
                            String sequenceId = jArray.getJSONObject(i).getString(MailListField.ID.getKey());
                            MailPart part = mailAccess.getMessageStorage().getAttachment("INBOX", id, sequenceId);
                            MailAttachmentTest.assertFalse((String)("No mail part found for sequence ID: " + sequenceId), (null == part ? 1 : 0) != 0);
                        }
                        continue;
                    }
                    MailAttachmentTest.fail((String)"Missing attachments although existence indicated through 'hasAttachments()'");
                }
            }
            finally {
                mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailAttachmentTest.fail((String)e.getMessage());
        }
    }

    public void testNoAttachmentMIMEMessageConverter() throws OXException, UnsupportedEncodingException {
        MailMessage testMail = MimeMessageConverter.convertMessage((byte[])RFC822_WO_ATTACH.getBytes(Charsets.US_ASCII));
        MailAttachmentTest.assertTrue((String)"Missing hasAttachment", (boolean)testMail.containsHasAttachment());
        MailAttachmentTest.assertFalse((String)"A message w/o attachments is marked to hold attachments", (boolean)testMail.hasAttachment());
    }

    public void testHasAttachmentMIMEMessageConverter() throws OXException, UnsupportedEncodingException {
        MailMessage testMail = MimeMessageConverter.convertMessage((byte[])RFC822_WITH_ATTACH.getBytes(Charsets.US_ASCII));
        MailAttachmentTest.assertTrue((String)"Missing hasAttachment", (boolean)testMail.containsHasAttachment());
        MailAttachmentTest.assertTrue((String)"A message with attachments is marked to NOT hold attachments", (boolean)testMail.hasAttachment());
    }

    public void testRFC2231() {
        try {
            SessionObject session = SessionObjectWrapper.createSessionObject((int)this.getUser(), (Context)new ContextImpl(this.getCid()), (String)"mail-test-session");
            session.setPassword(this.getPassword());
            MailMessage rfc2231Mail = MimeMessageConverter.convertMessage((byte[])RFC2231.getBytes(Charsets.US_ASCII));
            JsonMessageHandler messageHandler = new JsonMessageHandler(0, null, rfc2231Mail, DisplayMode.DISPLAY, false, (Session)session, UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId()), false, -1);
            new MailMessageParser().parseMailMessage(rfc2231Mail, (MailMessageHandler)messageHandler);
            JSONObject jObject = messageHandler.getJSONObject();
            if (jObject.has(MailJSONField.ATTACHMENTS.getKey())) {
                JSONArray jArray = jObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
                int len = jArray.length();
                MailAttachmentTest.assertTrue((String)"Missing attachments although existence indicated through 'hasAttachments()'", (len > 0 ? 1 : 0) != 0);
                for (int i = 0; i < len; ++i) {
                    JSONObject attachObj = jArray.getJSONObject(i);
                    if (!attachObj.has(MailJSONField.ATTACHMENT_FILE_NAME.getKey())) continue;
                    String filename = attachObj.getString(MailJSONField.ATTACHMENT_FILE_NAME.getKey());
                    MailAttachmentTest.assertTrue((String)("Unexpected filename: " + filename), ("\uc11c\uc601\uc9c4.txt".equals(filename) || "test \u00e4\u00f6\u00fc.txt".equals(filename) ? 1 : 0) != 0);
                }
            } else {
                MailAttachmentTest.fail((String)"Missing attachments although existence indicated through 'hasAttachments()'");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailAttachmentTest.fail((String)e.getMessage());
        }
    }
}

