/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.groupware.tasks.TaskAsserts;
import com.openexchange.groupware.tasks.TestTask;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class TestTaskTest
extends TestCase {
    protected TestTask task;
    protected TimeZone timezone = TimeZone.getTimeZone("Europe/Berlin");

    protected TestTask getNewTask() {
        TestTask newTask = new TestTask();
        newTask.setTimezone(this.timezone);
        return newTask;
    }

    @Before
    public void setUp() {
        this.task = new TestTask();
        this.task.setTimezone(this.timezone);
    }

    @Test
    public void testCalendarUsedShouldBeLenientWhenOverflowing() {
        Calendar cal = Calendar.getInstance(this.timezone);
        cal.set(2, 0);
        cal.set(5, 31);
        this.task.setStartDate(cal.getTime());
        this.task.checkConsistencyOf(1);
        this.task.startsTheFollowingDay();
        cal.setTime(this.task.getStartDate());
        TestTaskTest.assertEquals((String)"Should be the 1st day of the month", (int)1, (int)cal.get(5));
        TestTaskTest.assertEquals((String)"Should be February", (int)1, (int)cal.get(2));
    }

    @Test
    public void testCalendarUsedShouldBeLenientWhenUnderrunning() {
        Calendar cal = Calendar.getInstance(this.timezone);
        cal.set(2, 1);
        cal.set(5, 1);
        this.task.setStartDate(cal.getTime());
        this.task.checkConsistencyOf(1);
        this.task.startsTheDayBefore();
        cal.setTime(this.task.getStartDate());
        TestTaskTest.assertEquals((String)"Should be the 31st day of the month", (int)31, (int)cal.get(5));
        TestTaskTest.assertEquals((String)"Should be January", (int)0, (int)cal.get(2));
    }

    @Test
    public void testOXandJavaConventionsShouldBeTheSame() {
        TestTaskTest.assertEquals((String)"This will only work if an OX-monday is the same as a Java-monday", (int)2, (int)2);
    }

    @Test
    public void testTaskEverydayAtNoonStartingTomorrow() {
        this.task.startsAtNoon().startsTheFollowingDay().everyDay();
        Date now = new Date();
        long dateDiff = this.task.getStartDate().getTime() - now.getTime();
        TestTaskTest.assertTrue((String)"Should be at least 12 hours difference between now and noon, tomorrow", (dateDiff > 43200000L ? 1 : 0) != 0);
    }

    @Test
    public void testShouldNotBreakIfGivenStartDateButNotEndDate() {
        this.task.startsAtNoon();
        TestTaskTest.assertNull((Object)this.task.getEndDate());
        this.task.checkConsistencyOf(1);
        TestTaskTest.assertNotNull((Object)this.task.getEndDate());
    }

    @Test
    public void testShouldNotBreakIfGivenEndDateButNotStartDate() {
        this.task.endsAtNoon();
        TestTaskTest.assertNull((Object)this.task.getStartDate());
        this.task.checkConsistencyOf(1);
        TestTaskTest.assertNotNull((Object)this.task.getStartDate());
    }

    @Test
    public void testShouldNotBreakIfGivenEndDateBeforeStartDate() {
        this.task.startsInTheEvening().endsAtNoon();
        TestTaskTest.assertTrue((this.task.getEndDate().compareTo(this.task.getStartDate()) < 0 ? 1 : 0) != 0);
        this.task.checkConsistencyOf(1);
        TestTaskTest.assertTrue((this.task.getEndDate().compareTo(this.task.getStartDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testShouldNotBreakWhenToldToOccurTheFollowingDayWhileMissingStartDate() {
        this.task.startsTheFollowingDay();
        TestTaskTest.assertNotNull((Object)this.task.getStartDate());
        Date now = new Date();
        TaskAsserts.assertFirstDateOccursLaterThanSecond(this.task.getStartDate(), now);
    }

    @Test
    public void testTomorrowAndTheNextDayFromNowShouldBeTheSame() {
        Date now = new Date();
        TestTask task1 = this.getNewTask();
        task1.setStartDate(now);
        task1.setEndDate(now);
        task1.startsTheFollowingDay();
        task1.endsTheFollowingDay();
        TestTask task2 = this.getNewTask();
        task2.setStartDate(now);
        task2.setEndDate(now);
        task2.startsTomorrow();
        task2.endsTomorrow();
        TestTaskTest.assertTrue((String)"Start dates should be equal", (boolean)TaskAsserts.checkOXDatesAreEqual(task1.getStartDate(), task2.getStartDate()));
        TestTaskTest.assertTrue((String)"End dates should be equal", (boolean)TaskAsserts.checkOXDatesAreEqual(task1.getEndDate(), task2.getEndDate()));
    }

    @Test
    public void testShouldCopyNecessaryInformationForUpdate() {
        TestTask task1 = this.getNewTask();
        task1.setObjectID(666);
        task1.setLastModified(new Date());
        TestTask task2 = this.getNewTask().makeRelatedTo(task1);
        TestTaskTest.assertEquals((String)"To change a task, you need its timestamp for 'last_modified'", (Object)task1.getLastModified(), (Object)task2.getLastModified());
        TestTaskTest.assertEquals((String)"To change a task, you need its id", (int)task1.getObjectID(), (int)task2.getObjectID());
    }

    @Test
    public void testShiftingDateByOneDay() {
        Calendar now = Calendar.getInstance(this.timezone);
        Date shiftedDate = this.task.shiftDateByDays(now.getTime(), 1);
        Calendar tomorrow = Calendar.getInstance(this.timezone);
        tomorrow.setTime(now.getTime());
        tomorrow.set(5, now.get(5) + 1);
        TestTaskTest.assertEquals((String)"the shiftByDay-method should produce the same result as adding one to the date of a calendar", (long)tomorrow.getTimeInMillis(), (long)shiftedDate.getTime());
    }
}

