/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.tools;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.setuptools.TestContextToolkit;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;

public class CalendarAssertions {
    public static void assertUserParticipants(CalendarDataObject cdao, String ... users) {
        CalendarAssertions.assertParticipants(cdao, users, new String[0]);
    }

    public static void assertResourceParticipants(CalendarDataObject cdao, String ... resources) {
        CalendarAssertions.assertParticipants(cdao, new String[0], resources);
    }

    public static void assertParticipants(CalendarDataObject cdao, String[] users, String[] resources) {
        Assert.assertNotNull((String)"Participants should be set! ", (Object)cdao.getParticipants());
        TestContextToolkit tools = new TestContextToolkit();
        HashSet<UserParticipant> userParticipants = new HashSet<UserParticipant>(tools.users(cdao.getContext(), users));
        HashSet<ResourceParticipant> resourceParticipants = new HashSet<ResourceParticipant>(tools.resources(cdao.getContext(), resources));
        HashSet<Participant> unexpected = new HashSet<Participant>();
        for (Participant participant : cdao.getParticipants()) {
            if (userParticipants.remove(participant) || resourceParticipants.remove(participant)) continue;
            unexpected.add(participant);
        }
        StringBuilder problems = new StringBuilder();
        boolean mustFail = false;
        if (!unexpected.isEmpty()) {
            mustFail = true;
            problems.append("Didn't expect: ").append(CalendarAssertions.stringify(unexpected)).append(". ");
        }
        if (!userParticipants.isEmpty()) {
            mustFail = true;
            problems.append("Missing user participants: ").append(CalendarAssertions.stringify(userParticipants)).append(". ");
        }
        if (!resourceParticipants.isEmpty()) {
            mustFail = true;
            problems.append("Missing resource participants: ").append(CalendarAssertions.stringify(resourceParticipants)).append(". ");
        }
        if (mustFail) {
            Assert.fail((String)problems.toString());
        }
    }

    public static void assertInPrivateFolder(CommonAppointments appointments, Appointment appointment) throws OXException {
        for (Appointment currentAppointment : appointments.getPrivateAppointments()) {
            if (appointment.getObjectID() != currentAppointment.getObjectID()) continue;
            return;
        }
        Assert.fail((String)("Couldn't find " + appointment.getObjectID() + " in private appointments"));
    }

    private static String stringify(Set<? extends Participant> unexpected) {
        StringBuilder bob = new StringBuilder();
        for (Participant participant : unexpected) {
            bob.append(participant.getIdentifier()).append(": ").append(participant.getDisplayName()).append(" | ");
        }
        return bob.toString();
    }
}

