/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CalendarAssertions;
import java.sql.SQLException;

public class Node1077Test
extends CalendarSqlTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folders.unsharePrivateFolder(this.session, this.ctx);
        this.folders.unsharePrivateFolder(this.session2, this.ctx);
        this.folders.unsharePrivateFolder(this.session3, this.ctx);
        this.folders.unsharePrivateFolder(this.session4, this.ctx);
    }

    public void testShouldSupplyConflictingUserParticipants() throws SQLException, OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.participant1, this.participant3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.appointments.save(conflictingAppointment);
        Node1077Test.assertNotNull((Object)conflicts);
        Node1077Test.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        Node1077Test.assertEquals((int)appointment.getObjectID(), (int)conflict.getObjectID());
        CalendarAssertions.assertUserParticipants(conflict, this.user, this.participant1);
    }

    public void testShouldSupplyConflictingResourceParticipants() throws SQLException, OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithResourceParticipants(this.resource1, this.resource2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithResourceParticipants(this.resource1, this.resource3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.appointments.save(conflictingAppointment);
        Node1077Test.assertNotNull((Object)conflicts);
        Node1077Test.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        Node1077Test.assertEquals((int)appointment.getObjectID(), (int)conflict.getObjectID());
        CalendarAssertions.assertResourceParticipants(conflict, this.resource1);
    }

    public void testShouldSupplyConflictingUserParticipantsInGroup() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithGroupParticipants(this.group);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.member);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.appointments.save(conflictingAppointment);
        Node1077Test.assertNotNull((Object)conflicts);
        Node1077Test.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        Node1077Test.assertEquals((int)appointment.getObjectID(), (int)conflict.getObjectID());
        CalendarAssertions.assertUserParticipants(conflict, this.user, this.member);
    }

    public void testShouldSupplyTitleIfPermissionsAllowIt() throws OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.participant1, this.participant2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.participant1, this.participant3);
        conflictingAppointment.setIgnoreConflicts(false);
        CalendarDataObject[] conflicts = this.appointments.save(conflictingAppointment);
        Node1077Test.assertNotNull((Object)conflicts);
        Node1077Test.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        Node1077Test.assertEquals((String)appointment.getTitle(), (String)conflict.getTitle());
    }

    public void testShouldSuppressTitleIfPermissionsDenyIt() throws OXException, SQLException, OXException {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.participant1, this.participant2);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        this.appointments.switchUser(this.secondUser);
        CalendarDataObject conflictingAppointment = this.appointments.buildAppointmentWithUserParticipants(this.participant1, this.participant3);
        conflictingAppointment.setIgnoreConflicts(false);
        conflictingAppointment.setShownAs(1);
        CalendarDataObject[] conflicts = this.appointments.save(conflictingAppointment);
        Node1077Test.assertNotNull((Object)conflicts);
        Node1077Test.assertEquals((int)1, (int)conflicts.length);
        CalendarDataObject conflict = conflicts[0];
        Node1077Test.assertNull((Object)conflict.getTitle());
    }
}

