/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import org.junit.Assert;
import org.junit.Test;

public class Bug27309Test
extends CalDAVTest {
    @Test
    public void testChangeToDaily() throws Exception {
        String uid = Bug27309Test.randomUID();
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle(this.getClass().getCanonicalName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(TimeTools.D("next monday at 17:00"));
        appointment.setEndDate(TimeTools.D("next monday at 18:00"));
        appointment.setRecurrenceType(2);
        appointment.setDays(2);
        appointment.setInterval(1);
        super.create(appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        iCalResource.getVEvent().setProperty("RRULE", "FREQ=DAILY;INTERVAL=1;COUNT=3");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"recurrence type wrong", (long)1L, (long)appointment.getRecurrenceType());
        Assert.assertEquals((String)"interval wrong", (long)1L, (long)appointment.getInterval());
        Assert.assertEquals((String)"recurrence count wrong", (long)3L, (long)appointment.getOccurrence());
    }
}

