/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Bug22352Test
extends CalDAVTest {
    @Test
    public void testLongNumericResourceName() throws Exception {
        String uid = "2010042814505442675";
        String summary = "bug 22352";
        String location = "test";
        Date start = TimeTools.D("tomorrow at 3pm");
        Date end = TimeTools.D("tomorrow at 4pm");
        String iCal = Bug22352Test.generateICal(start, end, uid, summary, location);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        Bug22352Test.assertAppointmentEquals(appointment, start, end, uid, summary, location);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
    }
}

