/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICALFixtures;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.data.conversion.ical.ical4j.ICal4JParser;
import com.openexchange.data.conversion.ical.ical4j.internal.ResourceResolver;
import com.openexchange.data.conversion.ical.ical4j.internal.UserResolver;
import com.openexchange.data.conversion.ical.ical4j.internal.calendar.Participants;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.MockUserLookup;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.resource.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;

public abstract class AbstractICalParserTest
extends TestCase {
    protected ICALFixtures fixtures;
    protected ICalParser parser;
    protected MockUserLookup users;
    protected ResourceResolver oldResourceResolver;
    protected UserResolver oldUserResolver;

    protected void setUp() throws Exception {
        this.fixtures = new ICALFixtures();
        this.users = new MockUserLookup();
        this.parser = new ICal4JParser();
        this.oldUserResolver = Participants.userResolver;
        Participants.userResolver = new UserResolver(){

            public List<User> findUsers(List<String> mails, Context ctx) {
                LinkedList<User> found = new LinkedList<User>();
                for (String mail : mails) {
                    User user = AbstractICalParserTest.this.users.getUserByMail(mail);
                    if (user == null) continue;
                    found.add(user);
                }
                return found;
            }

            public User loadUser(int userId, Context ctx) throws OXException {
                return AbstractICalParserTest.this.users.getUser(userId);
            }
        };
        this.oldResourceResolver = Participants.resourceResolver;
        Participants.resourceResolver = new ResourceResolver(){
            private final List<Resource> resources = new ArrayList<Resource>(){
                {
                    Resource toaster = new Resource();
                    toaster.setDisplayName("Toaster");
                    toaster.setIdentifier(1);
                    this.add(toaster);
                    Resource deflector = new Resource();
                    deflector.setDisplayName("Deflector");
                    deflector.setIdentifier(2);
                    this.add(deflector);
                    Resource subspaceAnomaly = new Resource();
                    subspaceAnomaly.setDisplayName("Subspace Anomaly");
                    subspaceAnomaly.setIdentifier(3);
                    this.add(subspaceAnomaly);
                }
            };

            public List<Resource> find(List<String> names, Context ctx) throws OXException, OXException {
                ArrayList<Resource> retval = new ArrayList<Resource>();
                for (String name : names) {
                    for (Resource resource : this.resources) {
                        if (!resource.getDisplayName().equals(name)) continue;
                        retval.add(resource);
                    }
                }
                return retval;
            }

            public Resource load(int resourceId, Context ctx) throws OXException, OXException {
                return null;
            }
        };
    }

    protected List<User> U(int ... ids) {
        LinkedList<User> found = new LinkedList<User>();
        for (int i : ids) {
            try {
                found.add(this.users.getUser(i));
            }
            catch (OXException oXException) {
                // empty catch block
            }
        }
        return found;
    }

    protected void tearDown() throws Exception {
        Participants.userResolver = this.oldUserResolver;
        Participants.resourceResolver = this.oldResourceResolver;
        super.tearDown();
    }

    protected CalendarDataObject parseAppointment(String icalText, TimeZone defaultTZ) throws ConversionError {
        List<CalendarDataObject> appointments = this.parseAppointments(icalText, defaultTZ);
        if (appointments.size() == 0) {
            return null;
        }
        return appointments.get(0);
    }

    protected CalendarDataObject parseAppointment(String icalText) throws ConversionError {
        return this.parseAppointment(icalText, TimeZone.getDefault());
    }

    protected List<CalendarDataObject> parseAppointments(String icalText) throws ConversionError {
        return this.parseAppointments(icalText, TimeZone.getDefault());
    }

    protected List<CalendarDataObject> parseAppointments(String icalText, TimeZone defaultTZ) throws ConversionError {
        return this.parser.parseAppointments(icalText, defaultTZ, (Context)new ContextImpl(23), new ArrayList(), new ArrayList());
    }

    protected Task parseTask(String icalText, TimeZone defaultTZ) throws ConversionError {
        return this.parseTasks(icalText, defaultTZ).get(0);
    }

    protected Task parseTask(String icalText) throws ConversionError {
        return this.parseTasks(icalText).get(0);
    }

    protected List<Task> parseTasks(String icalText, TimeZone defaultTZ) throws ConversionError {
        return this.parser.parseTasks(icalText, defaultTZ, (Context)new ContextImpl(23), new ArrayList(), new ArrayList());
    }

    protected List<Task> parseTasks(String icalText) throws ConversionError {
        return this.parseTasks(icalText, TimeZone.getDefault());
    }

    protected Appointment appointmentWithRecurrence(String recurrence, Date start, Date end) throws ConversionError {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.veventWithSimpleProperties(start, end, "RRULE", recurrence);
        CalendarDataObject appointment = this.parseAppointment(icalText, utc);
        return appointment;
    }

    protected Task taskWithRecurrence(String recurrence, Date start, Date end) throws ConversionError {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        String icalText = this.fixtures.vtodoWithSimpleProperties(start, end, "RRULE", recurrence);
        Task task = this.parseTask(icalText, utc);
        return task;
    }

    protected void assertWarningWhenParsingAppointment(String icalText, String warning) throws ConversionError {
        ArrayList errors = new ArrayList();
        ArrayList warnings = new ArrayList();
        List result = this.parser.parseAppointments(icalText, TimeZone.getTimeZone("UTC"), (Context)new ContextImpl(23), errors, warnings);
        AbstractICalParserTest.assertTrue((0 != result.size() ? 1 : 0) != 0);
        AbstractICalParserTest.assertEquals((int)1, (int)warnings.size());
        AbstractICalParserTest.assertEquals((String)warning, (String)((ConversionWarning)warnings.get(0)).getSoleMessage());
    }

    protected void assertErrorWhenParsingAppointment(String icalText, String expectedError) throws ConversionError {
        ArrayList errors = new ArrayList();
        ArrayList warnings = new ArrayList();
        this.parser.parseAppointments(icalText, TimeZone.getTimeZone("UTC"), (Context)new ContextImpl(23), errors, warnings);
        AbstractICalParserTest.assertEquals((int)1, (int)errors.size());
        AbstractICalParserTest.assertEquals((String)expectedError, (String)((ConversionError)errors.get(0)).getSoleMessage());
    }

    protected void assertNothingHappensWhenParsingAppointment(String icalText) throws ConversionError {
        ArrayList errors = new ArrayList();
        ArrayList warnings = new ArrayList();
        List parsed = this.parser.parseAppointments(icalText, TimeZone.getTimeZone("UTC"), (Context)new ContextImpl(23), errors, warnings);
        AbstractICalParserTest.assertTrue((null == parsed || 0 == parsed.size() ? 1 : 0) != 0);
        AbstractICalParserTest.assertEquals((int)0, (int)errors.size());
        AbstractICalParserTest.assertEquals((int)0, (int)warnings.size());
    }

    protected void warningOnAppRecurrence(String recurrence, String warning) throws ConversionError {
        String icalText = this.fixtures.veventWithSimpleProperties(CommonAppointments.D("24/02/1981 10:00"), CommonAppointments.D("24/02/1981 12:00"), "RRULE", recurrence);
        this.assertWarningWhenParsingAppointment(icalText, warning);
    }
}

