/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.xing.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.xing.actions.XingTestAccount;
import com.openexchange.configuration.XingConfig;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public abstract class AbstractXingRequest<T extends AbstractAJAXResponse>
implements AJAXRequest<T> {
    public static final String XING_URL = "/ajax/xing";
    protected final boolean failOnError;
    protected final String token;
    protected final String secret;

    public AbstractXingRequest(boolean foe) {
        this(foe, XingTestAccount.DIMITRI_BRONKOWITSCH);
    }

    public AbstractXingRequest(boolean foe, XingTestAccount testAccount) {
        this.failOnError = foe;
        try {
            XingConfig.init();
        }
        catch (OXException ex) {
            ex.printStackTrace();
        }
        this.token = XingConfig.getProperty(testAccount.getToken());
        this.secret = XingConfig.getProperty(testAccount.getSecret());
    }

    @Override
    public String getServletPath() {
        return XING_URL;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public final AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        if (this.token != null) {
            params.add(new AJAXRequest.URLParameter("testToken", this.token));
        }
        if (this.secret != null) {
            params.add(new AJAXRequest.URLParameter("testSecret", this.secret));
        }
        this.setMoreParameters(params);
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    protected abstract void setMoreParameters(List<AJAXRequest.Parameter> var1);
}

