/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Before;

public class Bug7377Test
extends AbstractTaskTest {
    private AJAXClient client1;
    private AJAXClient client2;
    private TimeZone tz1;
    private TimeZone tz2;
    private int folder1;
    private int folder2;

    public Bug7377Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.tz1 = this.client1.getValues().getTimeZone();
        this.tz2 = this.client2.getValues().getTimeZone();
        this.folder1 = this.client1.getValues().getPrivateTaskFolder();
        this.folder2 = this.client2.getValues().getPrivateTaskFolder();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        if (null != this.client2) {
            this.client2.logout();
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLostFolderInfo() throws Throwable {
        Task task = new Task();
        task.setTitle("Test bug #7377");
        task.setParentFolderID(this.folder1);
        InsertResponse iResponse = this.client1.execute(new InsertRequest(task, this.tz1));
        iResponse.fillTask(task);
        try {
            ReminderObject[] reminder2;
            GetResponse gResponse = this.client1.execute(new GetRequest(this.getPrivateFolder(), task.getObjectID()));
            task.setLastModified(gResponse.getTimestamp());
            task.setNote("Updated with reminder");
            Date remindDate = new Date();
            task.setAlarm(remindDate);
            UpdateResponse uResponse = this.client1.execute(new UpdateRequest(task, this.tz1));
            task.setLastModified(uResponse.getTimestamp());
            RangeResponse rResponse = this.client1.execute(new RangeRequest(remindDate));
            if (rResponse.hasConflicts()) {
                System.out.println("Response has got " + rResponse.getConflicts().size() + " conflicts");
            }
            if (rResponse.getResponse() != null) {
                System.out.println("There is a response!");
                System.out.println("Response is " + rResponse.getResponse().getJSON());
                if (rResponse.hasError()) {
                    System.out.println("Response has got " + rResponse.getProblematics().length + " problematics");
                }
                System.out.println("Response has got " + (Object)((Object)rResponse.getException()) + " exceptions");
            }
            Bug7377Test.assertTrue((String)"Found no reminders for given timezone", (0 < (reminder2 = rResponse.getReminder(this.tz1)).length ? 1 : 0) != 0);
            ReminderObject reminder = rResponse.getReminderByTarget(this.tz1, task.getObjectID());
            Bug7377Test.assertNotNull((String)"Can't find reminder for task.", (Object)reminder);
            Bug7377Test.assertNotSame((String)"Found folder 0 for task reminder.", (Object)0, (Object)reminder.getFolder());
        }
        finally {
            this.client1.execute(new DeleteRequest(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublicFolderMove() throws Throwable {
        Task task = new Task();
        task.setParentFolderID(this.folder1);
        task.setTitle("Test bug #7377");
        Date remindDate = new Date();
        task.setAlarm(remindDate);
        Participant[] parts = new Participant[]{new UserParticipant(this.client1.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())};
        task.setParticipants(parts);
        InsertResponse response = this.client1.execute(new InsertRequest(task, this.tz1));
        response.fillTask(task);
        FolderObject folder = null;
        try {
            AbstractAJAXResponse response2 = this.client2.execute(new GetRequest(this.folder2, task.getObjectID()));
            Task task2 = ((GetResponse)response2).getTask(this.tz2);
            task2.setNote("Updated with reminder");
            task2.setAlarm(remindDate);
            response2 = this.client2.execute(new UpdateRequest(task2, this.tz2));
            task.setLastModified(response2.getTimestamp());
            FolderObject tmp = Create.setupPublicFolder("Bug7377TaskFolder1", 1, this.client1.getValues().getUserId());
            tmp.setParentFolderID(2);
            CommonInsertResponse response3 = this.client1.execute(new com.openexchange.ajax.folder.actions.InsertRequest((API)EnumAPI.OX_OLD, tmp));
            tmp.setObjectID(response3.getId());
            tmp.setLastModified(response3.getTimestamp());
            folder = tmp;
            task.setNote("Moved to public");
            task.removeAlarm();
            task.setParentFolderID(folder.getObjectID());
            response2 = this.client1.execute(new UpdateRequest(this.folder1, task, this.tz1));
            task.setLastModified(response2.getTimestamp());
            this.client2.execute(new GetRequest(folder.getObjectID(), task.getObjectID()));
            response2 = this.client1.execute(new RangeRequest(remindDate));
            ReminderObject reminder = ((RangeResponse)response2).getReminderByTarget(this.tz1, task.getObjectID());
            Bug7377Test.assertNotNull((String)"Can't find reminder for task.", (Object)reminder);
            Bug7377Test.assertNotSame((String)"Found folder 0 for task reminder.", (Object)0, (Object)reminder.getFolder());
            response2 = this.client2.execute(new RangeRequest(remindDate));
            reminder = ((RangeResponse)response2).getReminderByTarget(this.tz2, task.getObjectID());
            Bug7377Test.assertNotNull((String)"Can't find reminder for task.", (Object)reminder);
            Bug7377Test.assertNotSame((String)"Found folder 0 for task reminder.", (Object)0, (Object)reminder.getFolder());
        }
        finally {
            this.client1.execute(new DeleteRequest(task));
            if (null != folder) {
                this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
            }
        }
    }
}

