/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.GuestRecipient;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class PasswordResetServletTest
extends ShareTest {
    private OCLGuestPermission guestPermission;
    private ExtendedPermissionEntity guest;
    private FolderObject folder;
    private String shareURL;

    public PasswordResetServletTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        OCLGuestPermission lGuestPermission = PasswordResetServletTest.createNamedGuestPermission(PasswordResetServletTest.randomUID() + "@example.com", "Test Guest", "secret");
        int module = PasswordResetServletTest.randomModule();
        EnumAPI api = PasswordResetServletTest.randomFolderAPI();
        this.folder = this.insertSharedFolder(PasswordResetServletTest.randomFolderAPI(), module, this.getDefaultFolder(module), lGuestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : this.folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        PasswordResetServletTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        PasswordResetServletTest.checkPermissions(lGuestPermission, matchingPermission);
        ExtendedPermissionEntity lGuest = this.discoverGuestEntity(api, module, this.folder.getObjectID(), matchingPermission.getEntity());
        PasswordResetServletTest.checkGuestPermission(lGuestPermission, lGuest);
        this.shareURL = this.discoverShareURL(lGuest);
        GuestClient guestClient = this.resolveShare(this.shareURL, ((GuestRecipient)lGuestPermission.getRecipient()).getEmailAddress(), ((GuestRecipient)lGuestPermission.getRecipient()).getPassword());
        guestClient.checkShareModuleAvailable();
        this.guest = lGuest;
        this.guestPermission = lGuestPermission;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testResetPassword_passwordReset() throws Exception {
        URI shareUrl = new URI(this.shareURL);
        String[] pathSegments = shareUrl.getPath().split("/");
        String token = null;
        for (String segment : pathSegments) {
            Matcher matcher = Pattern.compile("[a-f0-9]{48}", 2).matcher(segment);
            if (!matcher.matches()) continue;
            token = matcher.group();
            break;
        }
        if (token == null) {
            PasswordResetServletTest.fail((String)"got no token from share link");
        }
        DefaultHttpClient httpClient = this.getSession().getHttpClient();
        HttpGet getConfirmationMail = new HttpGet(new URIBuilder().setScheme(this.client.getProtocol()).setHost(this.client.getHostname()).setPath("/ajax/share/reset/password").setParameter("share", token).build());
        HttpResponse getConfirmationMailResponse = httpClient.execute((HttpUriRequest)getConfirmationMail);
        EntityUtils.consume((HttpEntity)getConfirmationMailResponse.getEntity());
        PWResetData resetData = this.getConfirmationToken();
        HttpPost confirmPWReset = new HttpPost(new URIBuilder().setScheme(this.client.getProtocol()).setHost(this.client.getHostname()).setPath("/ajax/share/reset/password").build());
        String newPW = UUIDs.getUnformattedStringFromRandom();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("share", resetData.shareToken));
        params.add(new BasicNameValuePair("confirm", resetData.confirmationToken));
        params.add(new BasicNameValuePair("password", newPW));
        confirmPWReset.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse confirmResponse = httpClient.execute((HttpUriRequest)confirmPWReset);
        EntityUtils.consume((HttpEntity)confirmResponse.getEntity());
        PasswordResetServletTest.assertEquals((String)"Response was no redirect", (int)302, (int)confirmResponse.getStatusLine().getStatusCode());
        Header locationHeader = confirmResponse.getFirstHeader("Location");
        PasswordResetServletTest.assertNotNull((String)"Missing location header", (Object)locationHeader);
        URI location = new URI(locationHeader.getValue());
        String[] kvPairs = location.getRawFragment().split("&");
        String sessionId = null;
        for (String pair : kvPairs) {
            String[] splitted = pair.split("=");
            if (splitted.length != 2 || !"session".equals(splitted[0])) continue;
            sessionId = URLDecoder.decode(splitted[1], "UTF-8");
        }
        PasswordResetServletTest.assertNotNull((String)"Missing session ID in redirect location", sessionId);
        GuestClient guestClient = this.resolveShare(this.shareURL, ((GuestRecipient)this.guestPermission.getRecipient()).getEmailAddress(), newPW);
        guestClient.checkShareAccessible(this.guestPermission);
        guestClient.logout();
    }

    private PWResetData getConfirmationToken() throws Exception {
        List<GetMailsResponse.Message> messages = this.client.execute(new GetMailsRequest()).getMessages();
        PasswordResetServletTest.assertEquals((int)1, (int)messages.size());
        GetMailsResponse.Message message = messages.get(0);
        String url = message.getHeaders().get("X-Open-Xchange-Share-Reset-PW-URL");
        PasswordResetServletTest.assertNotNull((String)"Missing X-Open-Xchange-Share-Reset-PW-URL in confirmation mail", (Object)url);
        String query = new URI(url).getRawQuery();
        String[] kvPairs = query.split("&");
        PWResetData pwResetData = new PWResetData();
        for (String kvPair : kvPairs) {
            String[] kv = kvPair.split("=");
            if (kv.length != 2) continue;
            if ("confirm".equals(kv[0])) {
                pwResetData.confirmationToken = URLDecoder.decode(kv[1], "UTF-8");
                continue;
            }
            if (!"share".equals(kv[0])) continue;
            pwResetData.shareToken = URLDecoder.decode(kv[1], "UTF-8");
        }
        PasswordResetServletTest.assertNotNull((String)("Cannot extract share token from URL: " + url), (Object)pwResetData.shareToken);
        PasswordResetServletTest.assertNotNull((String)("Cannot extract confirmation token from URL: " + url), (Object)pwResetData.confirmationToken);
        return pwResetData;
    }

    private static final class PWResetData {
        private String shareToken;
        private String confirmationToken;

        private PWResetData() {
        }
    }
}

