/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.SendLinkRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.notification.ShareNotificationService;
import com.openexchange.share.notification.ShareNotifyExceptionCodes;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.json.JSONException;
import org.jsoup.nodes.Document;
import org.junit.Assert;

public class MailNotificationTest
extends ShareTest {
    private InfostoreTestManager infostoreTestManager;
    private FolderObject testFolder1;
    private FolderObject publicDriveFolder;
    private com.openexchange.file.storage.File image1;
    private com.openexchange.file.storage.File file1;
    private final String IMAGENAME1 = "image1.jpg";
    private final String IMAGETYPE1 = "image/jpeg";
    private final String FILENAME1 = "snippet1.ad";
    private final String FILETYPE1 = "text/plain";
    private Contact clientContact;
    private String clientFullName;
    private String clientEmail;
    private final String clientShareMessage = "Hey there, i've got some shares for you!";
    DateFormat dateFormat = null;
    UserValues userValues;
    private final String SIGNATURE_IMAGE = "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";

    public MailNotificationTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userValues = this.client.getValues();
        this.infostoreTestManager = new InfostoreTestManager(this.client);
        this.testFolder1 = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.userValues.getPrivateInfostoreFolder());
        this.publicDriveFolder = this.insertPublicFolder(EnumAPI.OX_NEW, 8);
        this.image1 = this.getFile(this.createFile(this.testFolder1, "image1.jpg", "image/jpeg").getId());
        this.file1 = this.getFile(this.createFile(this.testFolder1, "snippet1.ad", "text/plain").getId());
        this.initUserConfig();
        this.dateFormat = DateFormat.getDateInstance(2, this.userValues.getLocale());
    }

    private void initUserConfig() throws OXException, IOException, JSONException {
        com.openexchange.ajax.user.actions.GetRequest request = new com.openexchange.ajax.user.actions.GetRequest(this.client.getValues().getUserId(), this.client.getValues().getTimeZone());
        com.openexchange.ajax.user.actions.GetResponse response = this.client.execute(request);
        this.clientContact = response.getContact();
        this.clientFullName = String.format("%1$s %2$s", this.clientContact.getGivenName(), this.clientContact.getSurName());
        this.clientEmail = this.clientContact.getEmail1();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testNoMailsButWarningForSharedMailFolderOnCreate() throws Exception {
        FolderObject sharedFolder = Create.createPrivateFolder(MailNotificationTest.randomUID(), 7, this.client.getValues().getUserId(), new OCLPermission[0]);
        sharedFolder.setFullName(this.client.getValues().getInboxFolder() + "/" + sharedFolder.getFolderName());
        InsertRequest insertFolderReq = new InsertRequest((API)EnumAPI.OX_NEW, sharedFolder);
        this.client.execute(insertFolderReq);
        this.remember(sharedFolder);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        ArrayList<OCLPermission> newPermissions = new ArrayList<OCLPermission>(sharedFolder.getPermissions());
        newPermissions.add(Create.ocl(client2.getValues().getUserId(), false, false, 2, 4, 4, 0));
        FolderObject toUpdate = new FolderObject();
        toUpdate.setModule(7);
        toUpdate.setFullName(sharedFolder.getFullName());
        toUpdate.setPermissions(newPermissions);
        toUpdate.setLastModified(new Date());
        UpdateRequest updateReq = new UpdateRequest((API)EnumAPI.OX_NEW, toUpdate);
        updateReq.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL, "Look at this!");
        InsertResponse updateResp = this.client.execute(updateReq);
        MailNotificationTest.assertTrue((boolean)updateResp.getResponse().hasWarnings());
        OXException warning = (OXException)((Object)updateResp.getResponse().getWarnings().get(0));
        MailNotificationTest.assertEquals((String)ShareNotifyExceptionCodes.UNEXPECTED_ERROR.getPrefix(), (String)warning.getPrefix());
        MailNotificationTest.assertEquals((int)ShareNotifyExceptionCodes.UNEXPECTED_ERROR.getNumber(), (int)warning.getCode());
        GetResponse reloadResponse = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, sharedFolder.getFullName()));
        MailNotificationTest.assertFalse((boolean)reloadResponse.hasError());
        FolderObject reloadedFolder = reloadResponse.getFolder();
        MailNotificationTest.assertNotNull((Object)reloadedFolder);
        List<GetMailsResponse.Message> messages = this.client.execute(new GetMailsRequest()).getMessages();
        MailNotificationTest.assertEquals((int)0, (int)messages.size());
    }

    public void testUserGotAnImage() throws Exception {
        this.testUserGotA(this.testFolder1, this.image1, String.format("%1$s has shared the image \"%2$s\" with you.", this.clientFullName, this.image1.getFileName()), String.format("%1$s (%2$s) has shared the image \"%3$s\" with you. Please click the button below to view it.", this.clientFullName, this.clientEmail, this.image1.getFileName()), "View image", null);
    }

    public void testUserGotAnImageAndMessage() throws Exception {
        this.testUserGotA(this.testFolder1, this.image1, String.format("%1$s has shared the image \"%2$s\" with you.", this.clientFullName, this.image1.getFileName()), String.format("%1$s (%2$s) has shared the image \"%3$s\" with you and left you a message:", this.clientFullName, this.clientEmail, this.image1.getFileName()), "View image", "Hey there, i've got some shares for you!");
    }

    public void testUserGotAFile() throws Exception {
        this.testUserGotA(this.testFolder1, this.file1, String.format("%1$s has shared the file \"%2$s\" with you.", this.clientFullName, this.file1.getFileName()), String.format("%1$s (%2$s) has shared the file \"%3$s\" with you. Please click the button below to view it.", this.clientFullName, this.clientEmail, this.file1.getFileName()), "View file", null);
    }

    public void testUserGotAFileAndMessage() throws Exception {
        this.testUserGotA(this.testFolder1, this.file1, String.format("%1$s has shared the file \"%2$s\" with you.", this.clientFullName, this.file1.getFileName()), String.format("%1$s (%2$s) has shared the file \"%3$s\" with you and left you a message:", this.clientFullName, this.clientEmail, this.file1.getFileName()), "View file", "Hey there, i've got some shares for you!");
    }

    public void testUserGotAFolder() throws Exception {
        this.testUserGotA(this.testFolder1, null, String.format("%1$s has shared the folder \"%2$s\" with you.", this.clientFullName, this.testFolder1.getFolderName()), String.format("%1$s (%2$s) has shared the folder \"%3$s\" with you. Please click the button below to view it.", this.clientFullName, this.clientEmail, this.testFolder1.getFolderName()), "View folder", null);
    }

    public void testUserGotAFolderAndMessage() throws Exception {
        this.testUserGotA(this.testFolder1, null, String.format("%1$s has shared the folder \"%2$s\" with you.", this.clientFullName, this.testFolder1.getFolderName()), String.format("%1$s (%2$s) has shared the folder \"%3$s\" with you and left you a message:", this.clientFullName, this.clientEmail, this.testFolder1.getFolderName()), "View folder", "Hey there, i've got some shares for you!");
    }

    public void testAnonymousGotAFolder() throws Exception {
        this.testAnonymousGotA(this.testFolder1, null, String.format("%1$s has shared the folder \"%2$s\" with you.", this.clientFullName, this.testFolder1.getFolderName()), String.format("%1$s (%2$s) has shared the folder \"%3$s\" with you. Please click the button below to view it.", this.clientFullName, this.clientEmail, this.testFolder1.getFolderName()), "View folder", null, MailNotificationTest.randomUID(), new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(7L)));
    }

    public void testDontNotifyInternalsOnPublicFolderShare() throws Exception {
        this.testUserGotNoNotification(this.publicDriveFolder, null);
    }

    public void testGuestGetsMessageIfAddedViaFolderPermission() throws Exception {
        OCLGuestPermission guestPermission = MailNotificationTest.createNamedGuestPermission(MailNotificationTest.randomUID() + "@example.com", "TestUser_" + System.currentTimeMillis(), null);
        FolderObject toUpdate = new FolderObject();
        toUpdate.setObjectID(this.testFolder1.getObjectID());
        toUpdate.setLastModified(this.testFolder1.getLastModified());
        toUpdate.setFolderName(this.testFolder1.getFolderName());
        toUpdate.setPermissions(this.testFolder1.getPermissions());
        toUpdate.addPermission((OCLPermission)guestPermission);
        this.updateFolder(EnumAPI.OX_NEW, toUpdate, new ShareTest.RequestCustomizer<UpdateRequest>(){

            @Override
            public void customize(UpdateRequest request) {
                request.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL, "Hey there, i've got some shares for you!");
            }
        });
        GetMailsResponse.Message message = this.assertAndGetMessage();
        Document document = message.requireHtml();
        String initialSubject = String.format("%1$s has shared the folder \"%2$s\" with you.", this.clientFullName, this.testFolder1.getFolderName());
        String hasSharedString = String.format("%1$s (%2$s) has shared the folder \"%3$s\" with you and left you a message:", this.clientFullName, this.clientEmail, this.testFolder1.getFolderName());
        String viewItemStringString = "View folder";
        this.assertSubject(message.getMimeMessage(), initialSubject);
        this.assertHasSharedItems(document, hasSharedString);
        this.assertViewItems(document, viewItemStringString);
        this.assertShareMessage(document, "Hey there, i've got some shares for you!");
        this.assertSignatureText(document, "");
        this.assertSignatureImage(message);
    }

    public void testGuestGetsMessageIfAddedViaFilePermission() throws Exception {
        FileStorageGuestObjectPermission guestPermission = MailNotificationTest.asObjectPermission(MailNotificationTest.createNamedGuestPermission(MailNotificationTest.randomUID() + "@example.com", "TestUser_" + System.currentTimeMillis(), null));
        com.openexchange.file.storage.File testFile = this.insertFile(this.testFolder1.getObjectID());
        DefaultFile toUpdate = new DefaultFile();
        toUpdate.setId(testFile.getId());
        toUpdate.setFolderId(testFile.getFolderId());
        toUpdate.setLastModified(testFile.getLastModified());
        ArrayList<FileStorageGuestObjectPermission> newPermissions = new ArrayList<FileStorageGuestObjectPermission>(2);
        List oldPermissions = testFile.getObjectPermissions();
        if (oldPermissions != null) {
            newPermissions.addAll(oldPermissions);
        }
        newPermissions.add(guestPermission);
        toUpdate.setObjectPermissions(newPermissions);
        testFile = this.updateFile((com.openexchange.file.storage.File)toUpdate, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, new ShareTest.RequestCustomizer<UpdateInfostoreRequest>(){

            @Override
            public void customize(UpdateInfostoreRequest request) {
                request.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL, "Hey there, i've got some shares for you!");
            }
        });
        GetMailsResponse.Message message = this.assertAndGetMessage();
        Document document = message.requireHtml();
        String initialSubject = String.format("%1$s has shared the file \"%2$s\" with you.", this.clientFullName, testFile.getFileName());
        String hasSharedString = String.format("%1$s (%2$s) has shared the file \"%3$s\" with you and left you a message:", this.clientFullName, this.clientEmail, testFile.getFileName());
        String viewItemStringString = "View file";
        this.assertSubject(message.getMimeMessage(), initialSubject);
        this.assertHasSharedItems(document, hasSharedString);
        this.assertViewItems(document, viewItemStringString);
        this.assertShareMessage(document, "Hey there, i've got some shares for you!");
        this.assertSignatureText(document, "");
        this.assertSignatureImage(message);
    }

    public void testUserGotA(FolderObject testFolder, com.openexchange.file.storage.File file, String initialSubject, String hasSharedString, String viewItemString, String shareMessage) throws Exception {
        this.share(testFolder, file, MailNotificationTest.createNamedGuestPermission(MailNotificationTest.randomUID() + "@example.com", "TestUser_" + System.currentTimeMillis(), null), shareMessage);
        this.assertGotA(initialSubject, hasSharedString, viewItemString, shareMessage, null, null);
    }

    public void testAnonymousGotA(FolderObject testFolder, com.openexchange.file.storage.File file, String initialSubject, String hasSharedString, String viewItemString, String shareMessage, String password, Date expiryDate) throws Exception {
        OCLGuestPermission permission = MailNotificationTest.createAnonymousGuestPermission();
        ((AnonymousRecipient)permission.getRecipient()).setPassword(password);
        ((AnonymousRecipient)permission.getRecipient()).setExpiryDate(expiryDate);
        this.share(testFolder, file, permission, shareMessage);
        ShareTarget target = new ShareTarget(testFolder.getModule(), Integer.toString(testFolder.getObjectID()), file == null ? null : file.getId());
        this.client.execute(new SendLinkRequest(target, MailNotificationTest.randomUID() + "@example.com", shareMessage));
        this.assertGotA(initialSubject, hasSharedString, viewItemString, shareMessage, password, expiryDate);
    }

    public void assertGotA(String initialSubject, String hasSharedString, String viewItemString, String shareMessage, String password, Date expiryDate) throws Exception {
        GetMailsResponse.Message message = this.assertAndGetMessage();
        Document document = message.requireHtml();
        this.assertSubject(message.getMimeMessage(), initialSubject);
        this.assertHasSharedItems(document, hasSharedString);
        this.assertViewItems(document, viewItemString);
        if (shareMessage != null) {
            this.assertShareMessage(document, shareMessage);
        }
        this.assertSignatureText(document, "");
        this.assertSignatureImage(message);
        if (password != null) {
            this.assertPassword(document, password);
        }
        if (expiryDate != null) {
            this.assertExpiryDate(document, expiryDate);
        }
    }

    private void share(FolderObject testFolder, com.openexchange.file.storage.File file, OCLPermission guestPermission, final String shareMessage) throws Exception {
        if (null != file) {
            DefaultFile toUpdate = new DefaultFile();
            toUpdate.setId(file.getId());
            toUpdate.setFolderId(file.getFolderId());
            toUpdate.setLastModified(file.getLastModified());
            ArrayList<FileStorageGuestObjectPermission> newPermissions = new ArrayList<FileStorageGuestObjectPermission>(2);
            List oldPermissions = file.getObjectPermissions();
            if (oldPermissions != null) {
                newPermissions.addAll(oldPermissions);
            }
            newPermissions.add(MailNotificationTest.asObjectPermission(guestPermission));
            toUpdate.setObjectPermissions(newPermissions);
            file = this.updateFile((com.openexchange.file.storage.File)toUpdate, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, new ShareTest.RequestCustomizer<UpdateInfostoreRequest>(){

                @Override
                public void customize(UpdateInfostoreRequest request) {
                    request.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL, shareMessage);
                }
            });
        } else {
            FolderObject toUpdate = new FolderObject();
            toUpdate.setObjectID(testFolder.getObjectID());
            toUpdate.setLastModified(testFolder.getLastModified());
            toUpdate.setFolderName(testFolder.getFolderName());
            toUpdate.setPermissions(testFolder.getPermissions());
            toUpdate.addPermission(guestPermission);
            this.updateFolder(EnumAPI.OX_NEW, toUpdate, new ShareTest.RequestCustomizer<UpdateRequest>(){

                @Override
                public void customize(UpdateRequest request) {
                    request.setNotifyPermissionEntities(ShareNotificationService.Transport.MAIL, shareMessage);
                }
            });
        }
    }

    public void testUserGotNoNotification(FolderObject testFolder, com.openexchange.file.storage.File file) throws Exception {
        AJAXClient secondClient = new AJAXClient(AJAXClient.User.User2);
        int internalUserId = secondClient.getValues().getUserId();
        secondClient.logout();
        OCLPermission permission = new OCLPermission();
        permission.setEntity(internalUserId);
        permission.setAllPermission(2, 4, 0, 0);
        this.share(testFolder, file, permission, null);
        List<GetMailsResponse.Message> messages = this.client.execute(new GetMailsRequest()).getMessages();
        MailNotificationTest.assertEquals((int)0, (int)messages.size());
    }

    public com.openexchange.file.storage.File createFile(FolderObject folder, String fileName, String mimeType) throws Exception {
        long now = System.currentTimeMillis();
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(folder.getObjectID()));
        file.setTitle(fileName + now);
        file.setFileName(file.getTitle());
        file.setDescription(file.getTitle());
        file.setFileMIMEType(mimeType);
        this.infostoreTestManager.newAction((com.openexchange.file.storage.File)file, new File(TestInit.getTestProperty("ajaxPropertiesFile")));
        return file;
    }

    private GetMailsResponse.Message assertAndGetMessage() throws JSONException, MessagingException, OXException, IOException {
        List<GetMailsResponse.Message> messages = this.client.execute(new GetMailsRequest()).getMessages();
        MailNotificationTest.assertEquals((int)1, (int)messages.size());
        return messages.get(0);
    }

    private void assertSubject(MimeMessage mimeMessage, String expected) throws MessagingException {
        String subject = mimeMessage.getSubject();
        MailNotificationTest.assertEquals((String)expected, (String)subject);
    }

    private void assertHasSharedItems(Document document, String expected) {
        MailNotificationTest.assertEquals((String)expected, (String)document.getElementById("has_shared_items").ownText());
    }

    private void assertViewItems(Document document, String expected) {
        MailNotificationTest.assertEquals((String)expected, (String)document.getElementById("view_items").getElementsByTag("span").first().ownText());
    }

    private void assertShareMessage(Document document, String expected) {
        MailNotificationTest.assertEquals((String)expected, (String)document.getElementById("user_message").text());
    }

    private void assertExpiryDate(Document document, Date expiryDate) {
        MailNotificationTest.assertEquals((String)String.format("The link will expire on %1$s", this.dateFormat.format(expiryDate)), (String)document.getElementById("will_expire").ownText());
    }

    private void assertPassword(Document document, String password) {
        MailNotificationTest.assertEquals((String)("This link is password protected. You need the following password to open it: " + password), (String)document.getElementById("use_password").ownText());
    }

    private void assertSignatureText(Document document, String expected) {
        MailNotificationTest.assertEquals((String)expected, (String)document.getElementById("signature_text").ownText());
    }

    private void assertSignatureImage(GetMailsResponse.Message message) throws Exception {
        String src = message.requireHtml().getElementById("signature_image").attr("src");
        BodyPart image = message.getBodyPartByContentID("<" + src.substring(4) + ">");
        MailNotificationTest.assertNotNull((Object)image);
        byte[] expectedBytes = BaseEncoding.base64().decode((CharSequence)"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");
        byte[] imageBytes = ByteStreams.toByteArray((InputStream)image.getInputStream());
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])imageBytes);
    }
}

