/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.FileShare;
import com.openexchange.ajax.share.actions.FileSharesRequest;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.share.recipient.RecipientType;
import java.util.List;

public class ListFileSharesTest
extends ShareTest {
    public ListFileSharesTest(String name) {
        super(name);
    }

    public void testListSharedFilesToAnonymous() throws Exception {
        this.testListSharedFiles((FileStorageObjectPermission)ListFileSharesTest.randomGuestObjectPermission(RecipientType.ANONYMOUS));
    }

    public void testListSharedFilesToGuest() throws Exception {
        this.testListSharedFiles((FileStorageObjectPermission)ListFileSharesTest.randomGuestObjectPermission(RecipientType.GUEST));
    }

    public void testListSharedFilesToGroup() throws Exception {
        this.testListSharedFiles((FileStorageObjectPermission)new DefaultFileStorageObjectPermission(0, true, 1));
    }

    public void testListSharedFilesToUser() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        client2.logout();
        this.testListSharedFiles((FileStorageObjectPermission)new DefaultFileStorageObjectPermission(userId, false, 2));
    }

    private void testListSharedFiles(FileStorageObjectPermission permission) throws Exception {
        String filename = ListFileSharesTest.randomUID();
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8));
        File file = this.insertSharedFile(folder.getObjectID(), filename, permission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission objectPermission : file.getObjectPermissions()) {
            if (objectPermission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = objectPermission;
            break;
        }
        ListFileSharesTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        ListFileSharesTest.checkPermissions(permission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        ListFileSharesTest.checkGuestPermission(permission, guest);
    }

    public void testDontListPublicFiles() throws Exception {
        String filename = ListFileSharesTest.randomUID();
        FileStorageGuestObjectPermission guestPermission = ListFileSharesTest.randomGuestObjectPermission();
        FolderObject folder = this.insertPublicFolder(EnumAPI.OX_NEW, 8);
        File file = this.insertSharedFile(folder.getObjectID(), filename, (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        ListFileSharesTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        ListFileSharesTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        FileShare matchingShare = null;
        List<FileShare> shares = this.client.execute(new FileSharesRequest()).getShares(this.client.getValues().getTimeZone());
        for (FileShare share : shares) {
            if (!share.getId().equals(file.getId())) continue;
            matchingShare = share;
            break;
        }
        ListFileSharesTest.assertNull((String)"Share in public folder listed", matchingShare);
    }

    public void testDontListPublicFilesInSubfolder() throws Exception {
        String filename = ListFileSharesTest.randomUID();
        FileStorageGuestObjectPermission guestPermission = ListFileSharesTest.randomGuestObjectPermission();
        FolderObject folder = this.insertPublicFolder(EnumAPI.OX_NEW, 8);
        FolderObject subfolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, folder.getObjectID());
        File file = this.insertSharedFile(subfolder.getObjectID(), filename, (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        ListFileSharesTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        ListFileSharesTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        FileShare matchingShare = null;
        List<FileShare> shares = this.client.execute(new FileSharesRequest()).getShares(this.client.getValues().getTimeZone());
        for (FileShare share : shares) {
            if (!share.getId().equals(file.getId())) continue;
            matchingShare = share;
            break;
        }
        ListFileSharesTest.assertNull((String)"Share in public folder listed", matchingShare);
    }
}

