/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.DeleteLinkRequest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.ajax.share.actions.UpdateLinkRequest;
import com.openexchange.ajax.share.actions.UpdateLinkResponse;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class GetALinkTest
extends ShareTest {
    private InfostoreTestManager itm;
    private FolderObject infostore;
    private DefaultFile file;

    public GetALinkTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.itm = new InfostoreTestManager(this.client);
        UserValues values = this.client.getValues();
        this.infostore = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), values.getPrivateInfostoreFolder());
        long now = System.currentTimeMillis();
        FolderObject parent = this.infostore;
        this.file = new DefaultFile();
        this.file.setFolderId(String.valueOf(parent.getObjectID()));
        this.file.setTitle("GetALinkTest_" + now);
        this.file.setDescription(this.file.getTitle());
        this.itm.newAction((File)this.file);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.itm != null) {
            this.itm.cleanUp();
        }
        super.tearDown();
    }

    public void testCreateUpdateAndDeleteLinkForAFolder() throws Exception {
        ShareTarget target = new ShareTarget(8, Integer.toString(this.infostore.getObjectID()));
        GetLinkRequest getLinkRequest = new GetLinkRequest(target, this.client.getValues().getTimeZone());
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getShareLink().getShareURL();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = GetALinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkFolderAccessible(Integer.toString(this.infostore.getObjectID()), expectedPermission);
        File reloaded = (File)guestClient.getItem(this.infostore, this.file.getId(), false);
        GetALinkTest.assertNotNull((Object)reloaded);
        String newPassword = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        Date newExpiry = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        UpdateLinkRequest updateLinkRequest = new UpdateLinkRequest(target, this.client.getValues().getTimeZone(), getLinkResponse.getTimestamp().getTime());
        updateLinkRequest.setExpiryDate(newExpiry);
        updateLinkRequest.setPassword(newPassword);
        UpdateLinkResponse updateLinkResponse = this.client.execute(updateLinkRequest);
        GuestClient newClient = this.resolveShare(url, null, newPassword);
        int guestId = newClient.getValues().getUserId();
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.infostore.getObjectID(), guestId);
        GetALinkTest.assertNotNull((Object)guest);
        GetALinkTest.assertEquals((Object)newExpiry, (Object)guest.getExpiry());
        this.client.execute(new DeleteLinkRequest(target, updateLinkResponse.getTimestamp().getTime()));
        GetALinkTest.assertNull((String)"Share was not deleted", (Object)this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.infostore.getObjectID(), guestId));
        List reloadedFolderPermissions = this.getFolder(EnumAPI.OX_NEW, this.infostore.getObjectID()).getPermissions();
        GetALinkTest.assertEquals((String)"Permission was not deleted", (int)1, (int)reloadedFolderPermissions.size());
        GetALinkTest.assertEquals((String)"Permission was not deleted", (int)this.client.getValues().getUserId(), (int)((OCLPermission)reloadedFolderPermissions.get(0)).getEntity());
    }

    public void testCreateUpdateAndDeleteLinkForAFile() throws Exception {
        ShareTarget target = new ShareTarget(8, Integer.toString(this.infostore.getObjectID()), this.file.getId());
        GetLinkRequest getLinkRequest = new GetLinkRequest(target, this.client.getValues().getTimeZone());
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getShareLink().getShareURL();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = GetALinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkFileAccessible(this.file.getId(), expectedPermission);
        String newPassword = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        Date newExpiry = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        UpdateLinkRequest updateLinkRequest = new UpdateLinkRequest(target, this.client.getValues().getTimeZone(), getLinkResponse.getTimestamp().getTime());
        updateLinkRequest.setExpiryDate(newExpiry);
        updateLinkRequest.setPassword(newPassword);
        UpdateLinkResponse updateLinkResponse = this.client.execute(updateLinkRequest);
        GuestClient newClient = this.resolveShare(url, null, newPassword);
        int guestId = newClient.getValues().getUserId();
        newClient.checkFileAccessible(this.file.getId(), expectedPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), guestId);
        GetALinkTest.assertNotNull((Object)guest);
        GetALinkTest.assertEquals((Object)newExpiry, (Object)guest.getExpiry());
        this.client.execute(new DeleteLinkRequest(target, updateLinkResponse.getTimestamp().getTime()));
        GetALinkTest.assertNull((String)"Share was not deleted", (Object)this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), guestId));
        List objectPermissions = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata().getObjectPermissions();
        GetALinkTest.assertTrue((String)"Permission was not deleted", (null == objectPermissions || 0 == objectPermissions.size() ? 1 : 0) != 0);
    }

    public void testMoveFileWithExistingLink() throws Exception {
        ShareTarget target = new ShareTarget(8, Integer.toString(this.infostore.getObjectID()), this.file.getId());
        GetLinkRequest getLinkRequest = new GetLinkRequest(target, this.client.getValues().getTimeZone());
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getShareLink().getShareURL();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = GetALinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkFileAccessible(this.file.getId(), expectedPermission);
        guestClient.logout();
        DefaultFile toUpdate = new DefaultFile();
        toUpdate.setId(this.file.getId());
        toUpdate.setLastModified(new Date());
        toUpdate.setFolderId(Integer.toString(this.client.getValues().getPrivateInfostoreFolder()));
        File reloaded = this.updateFile((File)toUpdate, new File.Field[]{File.Field.FOLDER_ID});
        GetALinkTest.assertTrue((boolean)reloaded.getObjectPermissions().isEmpty());
    }
}

