/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.FileShare;
import com.openexchange.ajax.share.actions.FileSharesRequest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageGuestObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.modules.Module;
import com.openexchange.groupware.search.Order;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class FileStorageTransactionTest
extends ShareTest {
    private static final int TEST_FILES = 10;
    private FolderObject testFolder;
    private InfostoreTestManager itm;
    private List<DefaultFile> files;

    public FileStorageTransactionTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.itm = new InfostoreTestManager(this.client);
        this.testFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.client.getValues().getPrivateInfostoreFolder());
        this.files = new ArrayList<DefaultFile>(10);
        long now = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            DefaultFile file = new DefaultFile();
            file.setFolderId(String.valueOf(this.testFolder.getObjectID()));
            file.setTitle("FileStorageTransactionTest_" + now + "_" + i);
            file.setDescription(file.getTitle());
            this.itm.newAction((File)file);
            this.files.add(file);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.itm != null) {
            this.itm.cleanUp();
        }
        super.tearDown();
    }

    public void testShareItemsInFolder() throws Exception {
        DefaultFileStorageGuestObjectPermission permission = new DefaultFileStorageGuestObjectPermission();
        permission.setPermissions(1);
        permission.setRecipient((ShareRecipient)new AnonymousRecipient());
        Random r = new Random();
        ArrayList<DefaultFile> sharedFiles = new ArrayList<DefaultFile>(this.files.size());
        for (DefaultFile file : this.files) {
            if (!r.nextBoolean()) continue;
            file.setObjectPermissions(Collections.singletonList(permission));
            this.itm.updateAction((File)file, new File.Field[]{File.Field.OBJECT_PERMISSIONS}, new Date());
            sharedFiles.add(file);
        }
        ArrayList<FileShare> fileShares = new ArrayList<FileShare>(sharedFiles.size());
        List<FileShare> allShares = this.client.execute(new FileSharesRequest()).getShares(this.client.getValues().getTimeZone());
        block1: for (DefaultFile file : sharedFiles) {
            for (FileShare share : allShares) {
                if (!share.getId().equals(file.getId())) continue;
                fileShares.add(share);
                continue block1;
            }
        }
        FileStorageTransactionTest.assertEquals((String)"Wrong number of shares", (int)sharedFiles.size(), (int)fileShares.size());
        for (int i = 0; i < fileShares.size(); ++i) {
            FileShare share = (FileShare)((Object)fileShares.get(i));
            FileStorageTransactionTest.assertNotNull(share.getExtendedPermissions());
            FileStorageTransactionTest.assertEquals((int)1, (int)share.getExtendedPermissions().size());
            ExtendedPermissionEntity guest = share.getExtendedPermissions().get(0);
            FileStorageTransactionTest.checkGuestPermission((FileStorageObjectPermission)permission, guest);
            GuestClient guestClient = this.resolveShare(guest, permission.getRecipient());
            guestClient.checkShareModuleAvailable();
            guestClient.checkShareAccessible((FileStorageGuestObjectPermission)permission);
            AbstractColumnsResponse allResp = guestClient.execute(new AllInfostoreRequest(10, Metadata.columns((Metadata[])Metadata.HTTPAPI_VALUES_ARRAY), 1, Order.ASCENDING));
            Object[][] docs = allResp.getArray();
            FileStorageTransactionTest.assertEquals((int)1, (int)docs.length);
            FileStorageTransactionTest.assertEquals((Object)guestClient.getItem(), (Object)docs[0][allResp.getColumnPos(1)]);
        }
    }
}

