/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.RecipientType;
import java.util.Date;

public class ExpiredSharesTest
extends ShareTest {
    public ExpiredSharesTest(String name) {
        super(name);
    }

    public void testAccessExpiredShareRandomly() throws Exception {
        this.testAccessExpiredShare(ExpiredSharesTest.randomFolderAPI(), ExpiredSharesTest.randomModule());
    }

    public void noTestAccessExpiredShareExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testAccessExpiredShare(api, module);
            }
        }
    }

    private void testAccessExpiredShare(EnumAPI api, int module) throws Exception {
        this.testAccessExpiredShare(api, module, this.getDefaultFolder(module));
    }

    private void testAccessExpiredShare(EnumAPI api, int module, int parent) throws Exception {
        long expirationTime = 10000L;
        Date expires = new Date(System.currentTimeMillis() + expirationTime);
        OCLGuestPermission guestPermission = ExpiredSharesTest.createAnonymousGuestPermission();
        ((AnonymousRecipient)guestPermission.getRecipient()).setExpiryDate(expires);
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        ExpiredSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        ExpiredSharesTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        ExpiredSharesTest.checkGuestPermission(guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        Thread.sleep(expirationTime);
        GuestClient revokedGuestClient = new GuestClient(shareURL, guestPermission.getRecipient(), false);
        System.out.println("Share url for revoked guest: " + shareURL);
        ResolveShareResponse shareResolveResponse = revokedGuestClient.getShareResolveResponse();
        if (shareResolveResponse.getResponse() != null) {
            System.out.println("Share resolve response error messages: " + shareResolveResponse.getErrorMessage());
            System.out.println("Share resolve response exception: " + shareResolveResponse.getException().getMessage());
            System.out.println("Share resolve response content: " + shareResolveResponse.getResponse().getJSON());
        }
        if (null != shareResolveResponse.getConflicts()) {
            System.out.println("Share resolve response conflicts: " + shareResolveResponse.getConflicts().size());
        }
        ExpiredSharesTest.assertEquals((String)"Status wrong", (String)"not_found", (String)shareResolveResponse.getStatus());
        folder = this.getFolder(api, folder.getObjectID());
        for (OCLPermission permission : folder.getPermissions()) {
            ExpiredSharesTest.assertTrue((String)"Guest permission still present", (permission.getEntity() != matchingPermission.getEntity() ? 1 : 0) != 0);
        }
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        ExpiredSharesTest.assertNull((String)"guest entity still found", (Object)guest);
        if (RecipientType.ANONYMOUS.equals((Object)guestPermission.getRecipient().getType()) && null == ((AnonymousRecipient)guestPermission.getRecipient()).getPassword()) {
            this.checkGuestUserDeleted(matchingPermission.getEntity());
            guestClient.checkSessionAlive(true);
        } else {
            guestClient.checkFolderNotAccessible(String.valueOf(folder.getObjectID()));
            guestClient.logout();
        }
    }
}

