/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.java.util.UUIDs;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractRequest<T extends AbstractRequest<T>> {
    protected String scheme = "https";
    protected String hostname;
    protected String clientId;
    protected String redirectURI;
    protected String scope;
    protected String state = UUIDs.getUnformattedStringFromRandom();
    protected String responseType = "code";
    protected String sessionId;
    protected final Map<String, String> overrideParams = new HashMap<String, String>();
    protected final Map<String, String> headers = new HashMap<String, String>();

    public T setScheme(String scheme) {
        this.scheme = scheme;
        return (T)this;
    }

    public T setHostname(String hostname) {
        this.hostname = hostname;
        return (T)this;
    }

    public T setClientId(String clientId) {
        this.clientId = clientId;
        return (T)this;
    }

    public T setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return (T)this;
    }

    public T setScope(String scope) {
        this.scope = scope;
        return (T)this;
    }

    public T setState(String state) {
        this.state = state;
        return (T)this;
    }

    public T setResponseType(String responseType) {
        this.responseType = responseType;
        return (T)this;
    }

    public T setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return (T)this;
    }

    public T setParameter(String name, String value) {
        this.overrideParams.put(name, value);
        return (T)this;
    }

    public T setHeader(String name, String value) {
        this.headers.put(name, value);
        return (T)this;
    }

    List<NameValuePair> prepareParams() {
        return this.prepareParams(null);
    }

    List<NameValuePair> prepareParams(Map<String, String> requestSpecific) {
        HashMap<String, String> formParams = new HashMap<String, String>();
        if (this.clientId != null) {
            formParams.put("client_id", this.clientId);
        }
        if (this.redirectURI != null) {
            formParams.put("redirect_uri", this.redirectURI);
        }
        if (this.scope != null) {
            formParams.put("scope", this.scope);
        }
        if (this.state != null) {
            formParams.put("state", this.state);
        }
        if (this.responseType != null) {
            formParams.put("response_type", this.responseType);
        }
        if (this.sessionId != null) {
            formParams.put("session", this.sessionId);
        }
        if (requestSpecific != null) {
            for (String string : requestSpecific.keySet()) {
                formParams.put(string, requestSpecific.get(string));
            }
        }
        for (Map.Entry entry : this.overrideParams.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                formParams.remove(name);
                continue;
            }
            formParams.put(name, value);
        }
        LinkedList<NameValuePair> loginFormParams = new LinkedList<NameValuePair>();
        for (Map.Entry param : formParams.entrySet()) {
            loginFormParams.add((NameValuePair)new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
        return loginFormParams;
    }
}

