/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.PathRequest;
import com.openexchange.ajax.folder.actions.PathResponse;
import com.openexchange.ajax.folder.actions.RootRequest;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.oauth.provider.AbstractOAuthTest;
import com.openexchange.ajax.oauth.provider.OAuthClient;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.util.TimeZones;
import com.openexchange.oauth.provider.exceptions.OAuthInsufficientScopeException;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReadFoldersTest
extends AbstractOAuthTest {
    private FolderTestManager ftm;
    private UserValues values;
    private AJAXClient ajaxClient2;
    private FolderTestManager ftm2;
    private final ContentType contentType;
    private FolderObject privateSubfolder;
    private FolderObject publicSubfolder;
    private FolderObject sharedSubfolder;
    private int userId;
    private Set<Integer> groups;
    private EnumAPI api;
    private boolean altNames;
    private static final Map<Scope, ContentType> S2CT = new HashMap<Scope, ContentType>();
    private static final Set<EnumAPI> APIS;

    @Parameterized.Parameters(name="{1}_{2}_altNames={3}")
    public static Collection<Object[]> generateData() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(S2CT.size());
        for (Scope scope : S2CT.keySet()) {
            for (EnumAPI api : APIS) {
                for (boolean altNames : new boolean[]{true, false}) {
                    params.add(new Object[]{scope, S2CT.get(scope), api, altNames});
                }
            }
        }
        return params;
    }

    public ReadFoldersTest(Scope scope, ContentType contentType, EnumAPI api, boolean altNames) throws OXException {
        super(scope);
        this.contentType = contentType;
        this.api = api;
        this.altNames = altNames;
    }

    private int moduleId() {
        if (this.contentType == ContactContentType.getInstance()) {
            return 3;
        }
        if (this.contentType == CalendarContentType.getInstance()) {
            return 2;
        }
        if (this.contentType == TaskContentType.getInstance()) {
            return 1;
        }
        return -1;
    }

    private int privateFolderId() throws OXException, IOException, JSONException {
        return this.privateFolderId(this.ajaxClient);
    }

    private int privateFolderId(AJAXClient client) throws OXException, IOException, JSONException {
        if (this.contentType == ContactContentType.getInstance()) {
            return client.getValues().getPrivateContactFolder();
        }
        if (this.contentType == CalendarContentType.getInstance()) {
            return client.getValues().getPrivateAppointmentFolder();
        }
        if (this.contentType == TaskContentType.getInstance()) {
            return client.getValues().getPrivateTaskFolder();
        }
        return -1;
    }

    @Before
    public void setUp() throws Exception {
        this.ftm = new FolderTestManager(this.ajaxClient);
        this.values = this.ajaxClient.getValues();
        this.userId = this.values.getUserId();
        com.openexchange.ajax.user.actions.GetResponse getResponse = this.ajaxClient.execute(new com.openexchange.ajax.user.actions.GetRequest(this.userId, TimeZones.UTC));
        int[] userGroups = getResponse.getUser().getGroups();
        this.groups = new HashSet<Integer>();
        this.groups.add(0);
        if (userGroups != null) {
            for (int g : userGroups) {
                this.groups.add(g);
            }
        }
        this.privateSubfolder = this.ftm.generatePrivateFolder("oauth provider folder tree test - private " + this.contentType.toString() + " " + System.currentTimeMillis(), this.moduleId(), this.privateFolderId(), this.userId);
        this.publicSubfolder = this.ftm.generatePublicFolder("oauth provider folder tree test - public " + this.contentType.toString() + " " + System.currentTimeMillis(), this.moduleId(), 2, this.userId);
        this.ftm.insertFoldersOnServer(new FolderObject[]{this.privateSubfolder, this.publicSubfolder});
        this.ajaxClient2 = new AJAXClient(AJAXClient.User.User2);
        this.ftm2 = new FolderTestManager(this.ajaxClient2);
        OCLPermission adminPermission = new OCLPermission();
        adminPermission.setEntity(this.ajaxClient2.getValues().getUserId());
        adminPermission.setGroupPermission(false);
        adminPermission.setFolderAdmin(true);
        adminPermission.setAllPermission(128, 128, 128, 128);
        FolderObject client2PrivateFolder = this.ftm2.getFolderFromServer(this.privateFolderId(this.ajaxClient2));
        client2PrivateFolder.setPermissionsAsArray(new OCLPermission[]{adminPermission});
        client2PrivateFolder.setLastModified(new Date());
        this.ftm2.updateFolderOnServer(client2PrivateFolder);
        this.sharedSubfolder = this.ftm2.generateSharedFolder("oauth provider folder tree test - shared " + this.contentType.toString() + " " + System.currentTimeMillis(), this.moduleId(), this.privateFolderId(this.ajaxClient2), this.ajaxClient2.getValues().getUserId(), this.userId);
        this.ftm2.insertFoldersOnServer(new FolderObject[]{this.sharedSubfolder});
        this.client.logout();
        this.client = new OAuthClient(this.clientApp.getId(), this.clientApp.getSecret(), (String)this.clientApp.getRedirectURIs().get(0), this.scope);
    }

    @Test
    public void testFolderTreeNavigation() throws Exception {
        HashSet<Integer> expectedFolderIds = new HashSet<Integer>();
        if (this.api == EnumAPI.OUTLOOK) {
            expectedFolderIds.add(1);
        } else {
            expectedFolderIds.add(1);
            expectedFolderIds.add(2);
            expectedFolderIds.add(3);
        }
        RootRequest rootRequest = new RootRequest(this.api);
        rootRequest.setAltNames(this.altNames);
        Set<Integer> rootFolderIds = this.collectFolderIds(rootRequest);
        Assert.assertTrue((String)("Missing expected root folder(s). Expected " + expectedFolderIds + " but got " + rootFolderIds), (boolean)rootFolderIds.containsAll(expectedFolderIds));
        Assert.assertFalse((String)"Infostore root folder was contained in response but must not", (boolean)rootFolderIds.contains(9));
        ListRequest listPrivateRequest = new ListRequest((API)this.api, 1);
        listPrivateRequest.setAltNames(this.altNames);
        List<FolderObject> privateFolders = this.listFolders(listPrivateRequest);
        this.assertContentTypeAndPermissions(privateFolders);
        Set<Integer> privateFolderIds = ReadFoldersTest.collectFolderIds(privateFolders);
        Assert.assertTrue((String)("Missing expected private folder " + this.privateFolderId() + " in " + privateFolderIds), (boolean)privateFolderIds.contains(this.privateFolderId()));
        ListRequest listPrivateSubfoldersRequest = new ListRequest((API)this.api, this.privateFolderId());
        listPrivateSubfoldersRequest.setAltNames(this.altNames);
        List<FolderObject> privateSubFolders = this.listFolders(listPrivateSubfoldersRequest);
        this.assertContentTypeAndPermissions(privateSubFolders);
        Set<Integer> privateSubFolderIds = ReadFoldersTest.collectFolderIds(privateSubFolders);
        Assert.assertTrue((String)("Missing expected private subfolder " + this.privateSubfolder.getObjectID() + " in " + privateSubFolderIds), (boolean)privateSubFolderIds.contains(this.privateSubfolder.getObjectID()));
        ListRequest listPublicRequest = new ListRequest((API)this.api, 2);
        listPublicRequest.setAltNames(this.altNames);
        List<FolderObject> publicSubFolders = this.listFolders(listPublicRequest);
        this.assertContentTypeAndPermissions(publicSubFolders);
        Set<Integer> publicSubFolderIds = ReadFoldersTest.collectFolderIds(publicSubFolders);
        Assert.assertTrue((String)("Missing expected public subfolder " + this.publicSubfolder.getObjectID() + " in " + publicSubFolderIds), (boolean)publicSubFolderIds.contains(this.publicSubfolder.getObjectID()));
        ListRequest listSharedFolders = new ListRequest((API)this.api, 3);
        listSharedFolders.setAltNames(this.altNames);
        List<FolderObject> sharedFolders = this.listFolders(listSharedFolders);
        this.assertContentTypeAndPermissions(sharedFolders);
        FolderObject client2Folder = null;
        String sharedFolderId = "u:" + this.ajaxClient2.getValues().getUserId();
        for (FolderObject folder : sharedFolders) {
            if (!folder.getFullName().equals(sharedFolderId)) continue;
            client2Folder = folder;
            break;
        }
        Assert.assertNotNull((String)("Missing expected folder " + sharedFolderId + " below system shared folder"), (Object)client2Folder);
        ListRequest listSharedSubFolders = new ListRequest((API)this.api, sharedFolderId);
        listSharedSubFolders.setAltNames(this.altNames);
        Set<Integer> sharedSubFolderIds = this.collectFolderIds(listSharedSubFolders);
        Assert.assertTrue((String)("Missing expected shared subfolder " + this.sharedSubfolder.getObjectID() + " in " + sharedSubFolderIds), (boolean)sharedSubFolderIds.contains(this.sharedSubfolder.getObjectID()));
    }

    @Test
    public void testAllVisibleFolders() throws Exception {
        HashSet<Integer> expectedFolderIds = new HashSet<Integer>();
        VisibleFoldersRequest request = new VisibleFoldersRequest((API)this.api, this.contentType.toString());
        request.setAltNames(this.altNames);
        VisibleFoldersResponse response = this.client.execute(request);
        this.assertNoErrorsAndWarnings(response);
        List<FolderObject> privateFolders = ReadFoldersTest.toList(response.getPrivateFolders());
        this.assertContentTypeAndPermissions(privateFolders);
        expectedFolderIds.add(this.privateFolderId());
        expectedFolderIds.add(this.privateSubfolder.getObjectID());
        Assert.assertTrue((boolean)ReadFoldersTest.collectFolderIds(privateFolders).containsAll(expectedFolderIds));
        List<FolderObject> publicFolders = ReadFoldersTest.toList(response.getPublicFolders());
        this.assertContentTypeAndPermissions(publicFolders);
        expectedFolderIds.clear();
        expectedFolderIds.add(this.publicSubfolder.getObjectID());
        Assert.assertTrue((boolean)ReadFoldersTest.collectFolderIds(publicFolders).containsAll(expectedFolderIds));
        List<FolderObject> sharedFolders = ReadFoldersTest.toList(response.getSharedFolders());
        this.assertContentTypeAndPermissions(sharedFolders);
        expectedFolderIds.clear();
        expectedFolderIds.add(this.sharedSubfolder.getObjectID());
        Assert.assertTrue((boolean)ReadFoldersTest.collectFolderIds(sharedFolders).containsAll(expectedFolderIds));
    }

    @Test
    public void testUpdates() throws Exception {
        UpdatesRequest request = new UpdatesRequest(this.api, ListRequest.DEFAULT_COLUMNS, -1, null, new Date(this.privateSubfolder.getLastModified().getTime() - 1000L), AbstractUpdatesRequest.Ignore.NONE);
        request.setAltNames(this.altNames);
        FolderUpdatesResponse updatesResponse = this.client.execute(request);
        this.assertNoErrorsAndWarnings(updatesResponse);
        List<FolderObject> folders = updatesResponse.getFolders();
        this.assertContentTypeAndPermissions(folders);
        HashSet<Integer> expectedFolderIds = new HashSet<Integer>();
        expectedFolderIds.add(this.privateSubfolder.getObjectID());
        expectedFolderIds.add(this.publicSubfolder.getObjectID());
        expectedFolderIds.add(this.sharedSubfolder.getObjectID());
        Assert.assertTrue((boolean)ReadFoldersTest.collectFolderIds(folders).containsAll(expectedFolderIds));
    }

    @Test
    public void testPath() throws Exception {
        PathRequest request = new PathRequest((API)this.api, Integer.toString(this.privateSubfolder.getObjectID()));
        request.setAltNames(this.altNames);
        PathResponse pathResponse = this.client.execute(request);
        this.assertNoErrorsAndWarnings(pathResponse);
        List<FolderObject> folders = ReadFoldersTest.toList(pathResponse.getFolder());
        this.assertContentTypeAndPermissions(folders);
        HashSet<Integer> expectedFolderIds = new HashSet<Integer>();
        expectedFolderIds.add(this.privateSubfolder.getObjectID());
        expectedFolderIds.add(this.privateFolderId());
        expectedFolderIds.add(1);
        Set<Integer> collectFolderIds = ReadFoldersTest.collectFolderIds(folders);
        Assert.assertTrue((boolean)collectFolderIds.containsAll(expectedFolderIds));
        collectFolderIds.removeAll(expectedFolderIds);
        Assert.assertTrue((boolean)collectFolderIds.isEmpty());
    }

    @Test
    public void testGet() throws Exception {
        HashSet<Integer> folderIds = new HashSet<Integer>();
        folderIds.add(1);
        folderIds.add(2);
        folderIds.add(3);
        folderIds.add(this.privateFolderId());
        folderIds.add(this.privateSubfolder.getObjectID());
        folderIds.add(this.publicSubfolder.getObjectID());
        folderIds.add(this.sharedSubfolder.getObjectID());
        Iterator i$ = folderIds.iterator();
        while (i$.hasNext()) {
            int folderId = (Integer)i$.next();
            GetRequest request = new GetRequest((API)this.api, folderId);
            request.setAltNames(this.altNames);
            GetResponse response = this.client.execute(request);
            this.assertNoErrorsAndWarnings(response);
            this.assertContentTypeAndPermissions(response.getFolder());
        }
    }

    @Test
    public void testInsufficientScopeOnAllVisibleFolders() throws Exception {
        HashSet<Scope> invalidScopes = new HashSet<Scope>(S2CT.keySet());
        invalidScopes.remove(this.scope);
        for (Scope invalidScope : invalidScopes) {
            ContentType invalidContentType = S2CT.get(invalidScope);
            VisibleFoldersRequest request = new VisibleFoldersRequest(this.api, invalidContentType.toString(), VisibleFoldersRequest.DEFAULT_COLUMNS, false);
            request.setAltNames(this.altNames);
            VisibleFoldersResponse response = this.client.execute(request);
            this.assertFolderNotVisibleError(response, invalidScope);
        }
    }

    @Test
    public void testInsufficientScopeOnGet() throws Exception {
        HashSet<Scope> invalidScopes = new HashSet<Scope>(S2CT.keySet());
        invalidScopes.remove(this.scope);
        for (Scope invalidScope : invalidScopes) {
            ContentType invalidContentType = S2CT.get(invalidScope);
            VisibleFoldersRequest allRequest = new VisibleFoldersRequest(this.api, invalidContentType.toString(), VisibleFoldersRequest.DEFAULT_COLUMNS, false);
            allRequest.setAltNames(this.altNames);
            VisibleFoldersResponse allResponse = this.ajaxClient.execute(allRequest);
            this.assertNoErrorsAndWarnings(allResponse);
            LinkedList<FolderObject> allFolders = new LinkedList<FolderObject>();
            allFolders.addAll(ReadFoldersTest.toList(allResponse.getPrivateFolders()));
            allFolders.addAll(ReadFoldersTest.toList(allResponse.getPublicFolders()));
            allFolders.addAll(ReadFoldersTest.toList(allResponse.getSharedFolders()));
            for (FolderObject folder : allFolders) {
                GetResponse response;
                GetRequest getRequest;
                if (folder.getObjectID() < 0) {
                    getRequest = new GetRequest((API)this.api, folder.getFullName(), false);
                    getRequest.setAltNames(this.altNames);
                    response = this.client.execute(getRequest);
                } else {
                    getRequest = new GetRequest((API)this.api, folder.getObjectID(), false);
                    getRequest.setAltNames(this.altNames);
                    response = this.client.execute(getRequest);
                }
                this.assertFolderNotVisibleError(response, invalidScope);
            }
        }
    }

    private void assertFolderNotVisibleError(AbstractAJAXResponse response, Scope requiredScope) {
        OXException e = response.getException();
        Assert.assertTrue((e instanceof OAuthInsufficientScopeException || FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.equals(e) ? 1 : 0) != 0);
        if (e instanceof OAuthInsufficientScopeException) {
            Assert.assertEquals((Object)requiredScope.toString(), (Object)((OAuthInsufficientScopeException)e).getScope());
        }
    }

    private void assertContentTypeAndPermissions(List<FolderObject> folders) {
        for (FolderObject folder : folders) {
            this.assertContentTypeAndPermissions(folder);
        }
    }

    private void assertContentTypeAndPermissions(FolderObject folder) {
        Assert.assertTrue((String)("Unexpected module " + folder.getModule() + " for folder " + folder.getFolderName()), (this.moduleId() == folder.getModule() || 5 == folder.getModule() ? 1 : 0) != 0);
        boolean canRead = false;
        for (OCLPermission p : folder.getPermissions()) {
            if (p.getEntity() != this.userId && (!p.isGroupPermission() || !this.groups.contains(p.getEntity()))) continue;
            canRead = p.isFolderVisible();
            break;
        }
        Assert.assertTrue((String)("Request returned folder " + folder.toString() + " but folder must not be visible"), (boolean)canRead);
    }

    private void assertNoErrorsAndWarnings(AbstractAJAXResponse response) {
        Assert.assertFalse((boolean)response.hasError());
        Assert.assertFalse((boolean)response.hasWarnings());
    }

    private List<FolderObject> listFolders(AJAXRequest<ListResponse> request) throws OXException, IOException, JSONException {
        ListResponse response = this.client.execute(request);
        this.assertNoErrorsAndWarnings(response);
        ArrayList<FolderObject> folders = new ArrayList<FolderObject>();
        Iterator<FolderObject> it = response.getFolder();
        while (it.hasNext()) {
            folders.add(it.next());
        }
        return folders;
    }

    private static <T> List<T> toList(Iterator<T> iterator) {
        LinkedList<T> list = new LinkedList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static Set<Integer> collectFolderIds(List<FolderObject> folders) {
        Iterator<FolderObject> it = folders.iterator();
        return ReadFoldersTest.collectFolderIds(it);
    }

    private static Set<Integer> collectFolderIds(Iterator<FolderObject> it) {
        HashSet<Integer> folderIds = new HashSet<Integer>();
        while (it.hasNext()) {
            folderIds.add(it.next().getObjectID());
        }
        return folderIds;
    }

    private Set<Integer> collectFolderIds(AJAXRequest<ListResponse> request) throws OXException, IOException, JSONException {
        List<FolderObject> folders = this.listFolders(request);
        return ReadFoldersTest.collectFolderIds(folders);
    }

    @After
    public void tearDown() throws Exception {
        if (this.ftm != null) {
            this.ftm.cleanUp();
        }
        if (this.ftm2 != null) {
            this.ftm2.cleanUp();
        }
        if (this.ajaxClient2 != null) {
            this.ajaxClient2.logout();
        }
    }

    static {
        S2CT.put(Scope.newInstance((String[])new String[]{"read_contacts"}), (ContentType)ContactContentType.getInstance());
        S2CT.put(Scope.newInstance((String[])new String[]{"read_calendar"}), (ContentType)CalendarContentType.getInstance());
        S2CT.put(Scope.newInstance((String[])new String[]{"read_tasks"}), (ContentType)TaskContentType.getInstance());
        APIS = EnumSet.allOf(EnumAPI.class);
        APIS.remove(EnumAPI.EAS_FOLDERS);
    }
}

