/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mailaccount.actions.MailAccountUpdateParser;
import com.openexchange.ajax.mailaccount.actions.MailAccountUpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.AttributeSwitch;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.json.fields.GetSwitch;
import java.util.EnumSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MailAccountUpdateRequest
implements AJAXRequest<MailAccountUpdateResponse> {
    private final MailAccountDescription account;
    private final Set<Attribute> attributes;
    private final boolean failOnError;

    public MailAccountUpdateRequest(MailAccountDescription account, Set<Attribute> attributes, boolean failOnError) {
        this.account = account;
        this.attributes = attributes;
        this.failOnError = failOnError;
    }

    public MailAccountUpdateRequest(MailAccountDescription account, boolean failOnError) {
        this(account, EnumSet.allOf(Attribute.class), failOnError);
    }

    public MailAccountUpdateRequest(MailAccountDescription account, Set<Attribute> attributes) {
        this(account, attributes, true);
    }

    public MailAccountUpdateRequest(MailAccountDescription account) {
        this(account, true);
    }

    @Override
    public Object getBody() throws JSONException {
        try {
            JSONObject incrementalUpdate = new JSONObject();
            GetSwitch getter = new GetSwitch(this.account);
            for (Attribute attribute : this.attributes) {
                incrementalUpdate.put(attribute.getName(), attribute.doSwitch((AttributeSwitch)getter));
            }
            if (!this.attributes.contains(Attribute.ID_LITERAL)) {
                incrementalUpdate.put(Attribute.ID_LITERAL.getName(), this.account.getId());
            }
            return incrementalUpdate;
        }
        catch (OXException e) {
            throw new JSONException((Throwable)e);
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update")};
    }

    @Override
    public AbstractAJAXParser<MailAccountUpdateResponse> getParser() {
        return new MailAccountUpdateParser(this.failOnError);
    }

    @Override
    public String getServletPath() {
        return "/ajax/account";
    }
}

