/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailReferenceResponse
extends AbstractAJAXResponse {
    private static final Pattern MAIL_REF_PATTERN = Pattern.compile("^default([0-9]+)(.).*");
    private String separator;
    private int accountID;
    private String folder;
    private String mailID;
    private String reference;

    protected MailReferenceResponse(Response response) {
        super(response);
        this.reference = (String)response.getData();
        Matcher matcher = MAIL_REF_PATTERN.matcher(this.reference);
        if (matcher.matches()) {
            this.accountID = Integer.parseInt(matcher.group(1));
            this.separator = matcher.group(2);
            int firstSeparatorIndex = this.reference.indexOf(this.separator);
            int lastSeparatorIndex = this.reference.lastIndexOf(this.separator);
            String folderName = this.reference.substring(firstSeparatorIndex + 1, lastSeparatorIndex);
            this.mailID = this.reference.substring(lastSeparatorIndex + 1);
            this.folder = "default" + this.accountID + this.separator + folderName;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public int getAccountID() {
        return this.accountID;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getMailID() {
        return this.mailID;
    }

    public String getMailReference() {
        return this.reference;
    }
}

