/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.actions.SendResponse;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.ajax.user.actions.UpdateRequest;
import com.openexchange.ajax.user.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.mail.MailJSONField;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class MSISDNAddressTest
extends AbstractMailTest {
    private UserValues userValues = null;
    private Contact contactData;
    private String originalCellPhoneNumber;
    private final String validTestCellPhoneNumber = "491401234567890";
    private final String invalidTestCellPhoneNumber = "491501234567890";

    public MSISDNAddressTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userValues = this.client.getValues();
        GetResponse response = this.client.execute(new GetRequest(this.userValues.getUserId(), this.userValues.getTimeZone()));
        this.contactData = response.getContact();
        this.originalCellPhoneNumber = this.contactData.getCellularTelephone1();
        this.setCellularNumberOfContact("491401234567890");
    }

    @Override
    protected void tearDown() throws Exception {
        this.setCellularNumberOfContact(this.originalCellPhoneNumber);
        super.tearDown();
    }

    private void setCellularNumberOfContact(String cellPhoneNumber) throws OXException, IOException, JSONException {
        Contact changedContactData = new Contact();
        changedContactData.setObjectID(this.contactData.getObjectID());
        changedContactData.setInternalUserId(this.contactData.getInternalUserId());
        changedContactData.setCellularTelephone1("491401234567890");
        changedContactData.setLastModified(new Date());
        UpdateRequest updateRequest = new UpdateRequest(changedContactData, null);
        UpdateResponse updateResponse = this.client.execute(updateRequest);
        Date timestamp = updateResponse.getTimestamp();
        MSISDNAddressTest.assertNotNull((Object)timestamp);
    }

    public void testValidFromAddress() throws OXException, IOException, JSONException, SAXException {
        JSONObject createEMail = this.createEMail(MSISDNAddressTest.getSendAddress(this.client), "MSISDNSubject", MailContentType.PLAIN.name(), "Testing MSISDN as sender address");
        createEMail.put(MailJSONField.FROM.getKey(), (Object)"491401234567890");
        SendRequest request = new SendRequest(createEMail.toString());
        SendResponse response = this.client.execute(request);
        MSISDNAddressTest.assertTrue((String)"Send request failed", (response.getFolderAndID() != null && response.getFolderAndID().length > 0 ? 1 : 0) != 0);
    }

    public void testInvalidFromAddress() throws OXException, IOException, JSONException, SAXException {
        System.out.println("Testing invalid");
        JSONObject createEMail = this.createEMail(MSISDNAddressTest.getSendAddress(this.getClient()), "MSISDNSubject", MailContentType.PLAIN.name(), "Testing MSISDN as sender address");
        createEMail.put(MailJSONField.FROM.getKey(), (Object)"491501234567890");
        SendRequest request = new SendRequest(createEMail.toString(), false);
        SendResponse response = this.client.execute(request);
        MSISDNAddressTest.assertTrue((response.getException() != null ? 1 : 0) != 0);
        MSISDNAddressTest.assertEquals((Object)OXException.CATEGORY_USER_INPUT, (Object)response.getException().getCategory());
        MSISDNAddressTest.assertEquals((String)response.getErrorMessage(), (String)"MSG-0056", (String)response.getException().getErrorCode());
    }
}

