/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;

public class CreateFileWithIllegalCharactersTest
extends AbstractInfostoreTest {
    private final String[] RESERVED_NAMES = new String[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "CON", "NUL", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "AUX", "PRN"};

    public CreateFileWithIllegalCharactersTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateFileWithIllegalCharacters() throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("invalid<>:/?*\"\\|");
        NewInfostoreRequest req = new NewInfostoreRequest((File)file);
        NewInfostoreResponse resp = this.client.execute(req);
        CreateFileWithIllegalCharactersTest.assertNotNull((Object)((Object)resp));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)resp.hasError());
        OXException e = resp.getException();
        CreateFileWithIllegalCharactersTest.assertEquals((int)FileStorageExceptionCodes.ILLEGAL_CHARACTERS.getNumber(), (int)e.getCode());
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("<"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains(">"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains(":"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("/"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("?"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("*"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("\""));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("\\"));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("|"));
    }

    public void testCreateFileWithReservedName() throws Exception {
        for (String name : this.RESERVED_NAMES) {
            DefaultFile file = new DefaultFile();
            file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
            file.setFileName(name);
            NewInfostoreRequest req = new NewInfostoreRequest((File)file);
            NewInfostoreResponse resp = this.client.execute(req);
            CreateFileWithIllegalCharactersTest.assertNotNull((Object)((Object)resp));
            CreateFileWithIllegalCharactersTest.assertTrue((boolean)resp.hasError());
            OXException e = resp.getException();
            CreateFileWithIllegalCharactersTest.assertEquals((int)FileStorageExceptionCodes.RESERVED_NAME.getNumber(), (int)e.getCode());
            CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains(name));
        }
    }

    public void testCreateFilenameEndsWithWithespace() throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("test ");
        NewInfostoreRequest req = new NewInfostoreRequest((File)file);
        NewInfostoreResponse resp = this.client.execute(req);
        CreateFileWithIllegalCharactersTest.assertNotNull((Object)((Object)resp));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)resp.hasError());
        OXException e = resp.getException();
        CreateFileWithIllegalCharactersTest.assertEquals((int)FileStorageExceptionCodes.WHITESPACE_END.getNumber(), (int)e.getCode());
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("whitespace"));
    }

    public void testCreateFilenameEndsWithDot() throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("test.");
        NewInfostoreRequest req = new NewInfostoreRequest((File)file);
        NewInfostoreResponse resp = this.client.execute(req);
        CreateFileWithIllegalCharactersTest.assertNotNull((Object)((Object)resp));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)resp.hasError());
        OXException e = resp.getException();
        CreateFileWithIllegalCharactersTest.assertEquals((int)FileStorageExceptionCodes.WHITESPACE_END.getNumber(), (int)e.getCode());
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains("dot"));
    }

    public void testCreateReservedFolderName() throws Exception {
        DefaultFile file = new DefaultFile();
        file.setFolderId(String.valueOf(this.client.getValues().getPrivateInfostoreFolder()));
        file.setFileName("..");
        NewInfostoreRequest req = new NewInfostoreRequest((File)file);
        NewInfostoreResponse resp = this.client.execute(req);
        CreateFileWithIllegalCharactersTest.assertNotNull((Object)((Object)resp));
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)resp.hasError());
        OXException e = resp.getException();
        CreateFileWithIllegalCharactersTest.assertEquals((int)FileStorageExceptionCodes.ONLY_DOTS_NAME.getNumber(), (int)e.getCode());
        CreateFileWithIllegalCharactersTest.assertTrue((boolean)e.getMessage().contains(".."));
    }
}

