/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.List;

public class ShareFolderTest
extends AbstractAJAXSession {
    private AJAXClient secondClient;
    private UserValues secondUserValues;
    private FolderObject testFolder;
    private int parentId = -1;

    public ShareFolderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.secondClient = new AJAXClient(AJAXClient.User.User2);
        this.secondUserValues = this.secondClient.getValues();
        OCLPermission perm1 = Create.ocl(this.client.getValues().getUserId(), false, true, 128, 128, 128, 128);
        OCLPermission perm2 = Create.ocl(this.secondUserValues.getUserId(), false, false, 4, 4, 0, 0);
        this.parentId = this.client.getValues().getPrivateAppointmentFolder();
        this.testFolder = Create.folder(this.parentId, "TestShared" + System.currentTimeMillis(), 2, 1, perm1, perm2);
        InsertRequest insFolder = new InsertRequest((API)EnumAPI.OX_OLD, this.testFolder);
        InsertResponse folderInsertResponse = this.client.execute(insFolder);
        this.testFolder.setObjectID(folderInsertResponse.getId());
        this.testFolder.setLastModified(this.client.execute(new GetRequest((API)EnumAPI.OX_OLD, this.testFolder.getObjectID())).getTimestamp());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.secondClient != null) {
            this.secondClient.logout();
            this.secondClient = null;
            this.secondUserValues = null;
        }
        if (this.testFolder != null) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.testFolder));
            this.testFolder = null;
            this.parentId = -1;
        }
        super.tearDown();
    }

    public void testShareFolder() throws Throwable {
        int folderId = this.testFolder.getObjectID();
        int shareFolderId = 3;
        List<FolderObject> l = FolderTools.getSubFolders(this.secondClient, Integer.toString(3), true);
        ShareFolderTest.assertTrue((String)("No shared subfolder available for second user " + this.secondUserValues.getUserId()), (l != null && !l.isEmpty() ? 1 : 0) != 0);
        boolean found = false;
        block0: for (FolderObject virtualFO : l) {
            List<FolderObject> subList = FolderTools.getSubFolders(this.secondClient, virtualFO.getFullName(), true);
            for (FolderObject sharedFolder : subList) {
                if (sharedFolder.getObjectID() == this.parentId) {
                    List<FolderObject> subsubList = FolderTools.getSubFolders(this.secondClient, Integer.toString(this.parentId), true);
                    for (FolderObject subsharedFolder : subsubList) {
                        if (subsharedFolder.getObjectID() != folderId) continue;
                        found = true;
                        break block0;
                    }
                    continue;
                }
                if (sharedFolder.getObjectID() != folderId) continue;
                found = true;
                break block0;
            }
        }
        ShareFolderTest.assertTrue((String)("Folder " + folderId + " not beneath shared folder of second user " + this.secondUserValues.getUserId()), (boolean)found);
    }
}

