/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.drive.test;

import com.openexchange.ajax.drive.action.DeleteLinkRequest;
import com.openexchange.ajax.drive.action.GetLinkRequest;
import com.openexchange.ajax.drive.action.GetLinkResponse;
import com.openexchange.ajax.drive.test.AbstractDriveShareTest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.drive.DriveShareTarget;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.test.TestInit;
import java.io.File;
import java.util.List;

public class DeleteLinkTest
extends AbstractDriveShareTest {
    private InfostoreTestManager itm;
    private FolderObject rootFolder;
    private FolderObject folder;
    private DefaultFile file;

    public DeleteLinkTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.itm = new InfostoreTestManager(this.client);
        UserValues values = this.client.getValues();
        this.rootFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), values.getPrivateInfostoreFolder());
        this.folder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.rootFolder.getObjectID());
        long now = System.currentTimeMillis();
        this.file = new DefaultFile();
        this.file.setFolderId(String.valueOf(this.folder.getObjectID()));
        this.file.setTitle("GetLinkTest_" + now);
        this.file.setFileName(this.file.getTitle());
        this.file.setDescription(this.file.getTitle());
        this.file.setFileMD5Sum(this.getChecksum(new File(TestInit.getTestProperty("ajaxPropertiesFile"))));
        this.itm.newAction((com.openexchange.file.storage.File)this.file, new File(TestInit.getTestProperty("ajaxPropertiesFile")));
    }

    public void testDelete() throws Exception {
        DriveShareTarget target = new DriveShareTarget();
        target.setDrivePath("/" + this.folder.getFolderName());
        target.setName(this.file.getFileName());
        target.setChecksum(this.file.getFileMD5Sum());
        GetLinkRequest getLinkRequest = new GetLinkRequest(this.rootFolder.getObjectID(), target);
        GetLinkResponse getLinkResponse = this.client.execute(getLinkRequest);
        String url = getLinkResponse.getUrl();
        GuestClient guestClient = this.resolveShare(url, null, null);
        OCLGuestPermission expectedPermission = DeleteLinkTest.createAnonymousGuestPermission();
        expectedPermission.setEntity(guestClient.getValues().getUserId());
        guestClient.checkShareAccessible(expectedPermission);
        int guestID = guestClient.getValues().getUserId();
        this.client.execute(new DeleteLinkRequest(this.rootFolder.getObjectID(), target));
        ExtendedPermissionEntity guestEntity = target.isFolder() ? this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.folder.getObjectID(), guestID) : this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), guestID);
        DeleteLinkTest.assertNull((String)"Share was not deleted", (Object)guestEntity);
        List objectPermissions = this.client.execute(new GetInfostoreRequest(this.file.getId())).getDocumentMetadata().getObjectPermissions();
        DeleteLinkTest.assertTrue((String)"Permission was not deleted", (boolean)objectPermissions.isEmpty());
    }

    @Override
    public void tearDown() throws Exception {
        this.itm.cleanUp();
        super.tearDown();
    }
}

