/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.CopyRequest;
import com.openexchange.ajax.contact.action.CopyResponse;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;
import org.json.JSONObject;

public class CopyTest
extends AbstractContactTest {
    private int objectId1;
    private long ts1;
    private long ts2;
    private int objectId2;
    private int targetFolder;
    private FolderObject folder;

    public CopyTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCopy() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setSurName("testCopy");
        contactObj.setParentFolderID(this.contactFolderId);
        this.objectId1 = this.insertContact(contactObj);
        this.folder = Create.createPrivateFolder("testCopy", 3, this.userId, new OCLPermission[0]);
        this.folder.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        InsertResponse folderCreateResponse = this.client.execute(new InsertRequest((API)EnumAPI.OUTLOOK, this.folder));
        folderCreateResponse.fillObject((DataObject)this.folder);
        this.targetFolder = this.folder.getObjectID();
        CopyRequest request = new CopyRequest(this.objectId1, this.contactFolderId, this.targetFolder, true);
        CopyResponse response = this.client.execute(request);
        if (response.hasError()) {
            CopyTest.fail((String)("json error: " + response.getErrorMessage()));
        }
        this.objectId2 = 0;
        JSONObject data = (JSONObject)response.getData();
        if (data.has("id")) {
            this.objectId2 = data.getInt("id");
        } else {
            CopyTest.fail((String)"Could not find copied contact.");
        }
        GetRequest getFirstContactRequest = new GetRequest(this.contactFolderId, this.objectId1, this.tz);
        GetResponse firstContactResponse = this.client.execute(getFirstContactRequest);
        Contact firstContact = firstContactResponse.getContact();
        this.ts1 = firstContactResponse.getResponse().getTimestamp().getTime();
        GetRequest getSecondContactRequest = new GetRequest(this.targetFolder, this.objectId2, this.tz);
        GetResponse seconContactResponse = this.client.execute(getSecondContactRequest);
        Contact secondContact = seconContactResponse.getContact();
        secondContact.setObjectID(this.objectId1);
        secondContact.setParentFolderID(this.contactFolderId);
        this.ts2 = seconContactResponse.getResponse().getTimestamp().getTime();
        this.compareObject(firstContact, secondContact, false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contactFolderId, this.objectId1, new Date(this.ts1), false));
        if (this.objectId2 > 0) {
            this.client.execute(new DeleteRequest(this.targetFolder, this.objectId2, new Date(this.ts2), false));
        }
        this.client.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OUTLOOK, this.folder));
        super.tearDown();
    }
}

