/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.group.actions.SearchRequest;
import com.openexchange.ajax.group.actions.SearchResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;

public class Bug41794Test
extends AbstractAJAXSession {
    private AJAXClient client2;
    private AJAXClient client3;
    private CalendarTestManager ctm1;
    private CalendarTestManager ctm2;
    private CalendarTestManager ctm3;
    private String groupParticipant;
    private Appointment appointment;

    public Bug41794Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.client3 = new AJAXClient(AJAXClient.User.User3);
        this.groupParticipant = AJAXConfig.getProperty(AJAXConfig.Property.GROUP_PARTICIPANT);
        this.ctm1 = new CalendarTestManager(this.client);
        this.ctm2 = new CalendarTestManager(this.client2);
        this.ctm3 = new CalendarTestManager(this.client3);
        this.appointment = new Appointment();
        this.appointment.setTitle(((Object)((Object)this)).getClass().getSimpleName());
        this.appointment.setStartDate(TimeTools.D("01.11.2015 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.11.2015 09:00"));
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        UserParticipant up = new UserParticipant(this.client.getValues().getUserId());
        GroupParticipant gp = this.getGroupParticipant(this.groupParticipant);
        this.appointment.setParticipants(new Participant[]{up, gp});
    }

    public void testBug41794() throws Exception {
        this.ctm1.insert(this.appointment);
        this.appointment.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        this.ctm2.delete(this.appointment);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        Appointment loadedAppointment = this.ctm1.get(this.appointment);
        for (UserParticipant up : loadedAppointment.getUsers()) {
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug41794Test.fail((String)"Did not expect participant.");
        }
        loadedAppointment = this.ctm3.get(this.client3.getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID());
        loadedAppointment.setAlarm(15);
        loadedAppointment.setLastModified(new Date(Long.MAX_VALUE));
        loadedAppointment.setIgnoreConflicts(true);
        this.ctm3.confirm(loadedAppointment, 1, "message");
        this.ctm3.update(loadedAppointment);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        loadedAppointment = this.ctm1.get(this.appointment);
        for (UserParticipant up : loadedAppointment.getUsers()) {
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug41794Test.fail((String)("Did not expect participant: " + up.getIdentifier()));
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ctm2.cleanUp();
        this.ctm3.cleanUp();
        super.tearDown();
    }

    private GroupParticipant getGroupParticipant(String groupParticipant) throws OXException, IOException, JSONException {
        SearchResponse response = this.getClient().execute(new SearchRequest(groupParticipant));
        Group[] group = response.getGroups();
        int groupParticipantId = group[0].getIdentifier();
        GroupParticipant gpart = new GroupParticipant(groupParticipantId);
        return gpart;
    }
}

