/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;

public class Bug38404Test
extends AbstractAJAXSession {
    private AJAXClient client2;
    private CalendarTestManager ctm1;
    private CalendarTestManager ctm2;
    private Appointment appointment;

    public Bug38404Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm1 = new CalendarTestManager(this.client);
        this.ctm2 = new CalendarTestManager(this.client2);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 38404");
        this.appointment.setStartDate(TimeTools.D("10.08.2015 08:00"));
        this.appointment.setEndDate(TimeTools.D("10.08.2015 09:00"));
        UserParticipant user1 = new UserParticipant(this.client.getValues().getUserId());
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        this.appointment.setParticipants(new Participant[]{user1, user2});
        this.appointment.setUsers(new UserParticipant[]{user1, user2});
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
    }

    public void testBug38404() throws Exception {
        this.ctm1.insert(this.appointment);
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(28);
        this.appointment.setInterval(2);
        this.ctm1.update(this.appointment);
        this.appointment.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        this.ctm2.confirm(this.appointment, 1, "yes", 1);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        Appointment loaded = this.ctm1.get(this.appointment);
        Bug38404Test.assertNotNull((String)"Missing change exception.", (Object)loaded.getChangeException());
        Bug38404Test.assertEquals((String)"Wrong amount of change exceptions.", (int)1, (int)loaded.getChangeException().length);
        Bug38404Test.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getUsers().length);
        for (UserParticipant up : loaded.getUsers()) {
            if (up.getIdentifier() == this.client.getValues().getUserId()) {
                Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)1, (int)up.getConfirm());
                continue;
            }
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)0, (int)up.getConfirm());
        }
        Appointment[] all = this.ctm2.all(this.client2.getValues().getPrivateAppointmentFolder(), TimeTools.D("11.08.2015 08:00"), TimeTools.D("11.08.2015 09:00"));
        int exceptionId = 0;
        for (Appointment app : all) {
            if (app.getRecurrenceID() != this.appointment.getObjectID() || app.getRecurrenceID() == app.getObjectID()) continue;
            exceptionId = app.getObjectID();
            break;
        }
        Bug38404Test.assertFalse((String)"Unable to find exception.", (exceptionId == 0 ? 1 : 0) != 0);
        Appointment loadedException = this.ctm2.get(this.client2.getValues().getPrivateAppointmentFolder(), exceptionId);
        Bug38404Test.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loadedException.getUsers().length);
        for (UserParticipant up : loadedException.getUsers()) {
            if (up.getIdentifier() == this.client.getValues().getUserId()) {
                Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)1, (int)up.getConfirm());
                continue;
            }
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)1, (int)up.getConfirm());
        }
        Appointment updateAlarm = new Appointment();
        updateAlarm.setObjectID(this.appointment.getObjectID());
        updateAlarm.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        updateAlarm.setAlarm(15);
        updateAlarm.setLastModified(new Date(Long.MAX_VALUE));
        this.ctm2.update(updateAlarm);
        loaded = this.ctm1.get(this.appointment);
        Bug38404Test.assertNotNull((String)"Missing change exception.", (Object)loaded.getChangeException());
        Bug38404Test.assertEquals((String)"Wrong amount of change exceptions.", (int)1, (int)loaded.getChangeException().length);
        Bug38404Test.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loaded.getUsers().length);
        for (UserParticipant up : loaded.getUsers()) {
            if (up.getIdentifier() == this.client.getValues().getUserId()) {
                Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)1, (int)up.getConfirm());
                continue;
            }
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)0, (int)up.getConfirm());
        }
        loadedException = this.ctm2.get(this.client2.getValues().getPrivateAppointmentFolder(), exceptionId);
        Bug38404Test.assertEquals((String)"Wrong amount of participants.", (int)2, (int)loadedException.getUsers().length);
        for (UserParticipant up : loadedException.getUsers()) {
            if (up.getIdentifier() == this.client.getValues().getUserId()) {
                Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)1, (int)up.getConfirm());
                continue;
            }
            if (up.getIdentifier() != this.client2.getValues().getUserId()) continue;
            Bug38404Test.assertEquals((String)("Wrong confirmation status for user: " + up.getIdentifier()), (int)1, (int)up.getConfirm());
        }
    }

    public void testSomethingElse() throws Exception {
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(28);
        this.appointment.setInterval(2);
        this.ctm1.insert(this.appointment);
        Appointment loaded = this.ctm1.get(this.appointment);
        Bug38404Test.assertEquals((String)"Wrong start.", (Object)TimeTools.D("11.08.2015 08:00"), (Object)loaded.getStartDate());
        Bug38404Test.assertEquals((String)"Wrong end.", (Object)TimeTools.D("11.08.2015 09:00"), (Object)loaded.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ctm2.cleanUp();
        super.tearDown();
    }
}

