/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleTest
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleTest.class);

    public MultipleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMultipleInsert() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testMultipleInsert");
        appointmentObj.setIgnoreConflicts(true);
        AJAXSession ajaxSession = new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId());
        InsertRequest insertRequest1 = new InsertRequest(appointmentObj, this.timeZone, true);
        InsertRequest insertRequest2 = new InsertRequest(appointmentObj, this.timeZone, true);
        InsertRequest insertRequest3 = new InsertRequest(appointmentObj, this.timeZone, true);
        MultipleRequest multipleInsertRequest = MultipleRequest.create(insertRequest1, insertRequest2, insertRequest3);
        MultipleResponse multipleInsertResponse = (MultipleResponse)Executor.execute(ajaxSession, multipleInsertRequest);
        MultipleTest.assertFalse((String)"first insert request has errors: ", (boolean)((AbstractAJAXResponse)((Object)multipleInsertResponse.getResponse(0))).hasError());
        MultipleTest.assertFalse((String)"second insert request has errors: ", (boolean)((AbstractAJAXResponse)((Object)multipleInsertResponse.getResponse(1))).hasError());
        MultipleTest.assertFalse((String)"third insert request has errors: ", (boolean)((AbstractAJAXResponse)((Object)multipleInsertResponse.getResponse(2))).hasError());
        int objectId1 = ((CommonInsertResponse)((Object)multipleInsertResponse.getResponse(0))).getId();
        int objectId2 = ((CommonInsertResponse)((Object)multipleInsertResponse.getResponse(1))).getId();
        int objectId3 = ((CommonInsertResponse)((Object)multipleInsertResponse.getResponse(2))).getId();
        Appointment loadAppointment = MultipleTest.loadAppointment(this.getWebConversation(), objectId3, appointmentFolderId, this.timeZone, this.getHostName(), this.getSessionId());
        Date modified = loadAppointment.getLastModified();
        DeleteRequest deleteRequest1 = new DeleteRequest(objectId1, appointmentFolderId, modified);
        DeleteRequest deleteRequest2 = new DeleteRequest(objectId2, appointmentFolderId, modified);
        DeleteRequest deleteRequest3 = new DeleteRequest(objectId3, appointmentFolderId, modified);
        MultipleRequest.create(deleteRequest1, deleteRequest2, deleteRequest3);
        MultipleResponse multipleDeleteResponse = (MultipleResponse)Executor.execute(ajaxSession, multipleInsertRequest);
        MultipleTest.assertFalse((String)"first delete request has errors: ", (boolean)((AbstractAJAXResponse)((Object)multipleDeleteResponse.getResponse(0))).hasError());
        MultipleTest.assertFalse((String)"second delete request has errors: ", (boolean)((AbstractAJAXResponse)((Object)multipleDeleteResponse.getResponse(1))).hasError());
        MultipleTest.assertFalse((String)"third delete request has errors: ", (boolean)((AbstractAJAXResponse)((Object)multipleDeleteResponse.getResponse(2))).hasError());
    }

    public void _testTonnenInsert() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
        InsertRequest[] inserts = new InsertRequest[1000];
        for (int i = 0; i < inserts.length; ++i) {
            Appointment appointmentObj = this.createAppointmentObject("testMultipleInsert");
            appointmentObj.setIgnoreConflicts(true);
            inserts[i] = new InsertRequest(appointmentObj, client.getValues().getTimeZone(), true);
        }
        Executor.execute(client, MultipleRequest.create(inserts));
    }
}

