/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.ResourceTest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.group.GroupTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTest
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(ListTest.class);
    private AJAXClient client1;
    private CalendarTestManager ctm1;
    private FolderTestManager ftm;
    private FolderObject folder;

    public ListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = new AJAXClient(AJAXClient.User.User1);
        this.ctm1 = new CalendarTestManager(this.client1);
        this.ctm1.setFailOnError(true);
        this.ftm = new FolderTestManager(this.client1);
    }

    public void testList() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testList");
        appointmentObj.setIgnoreConflicts(true);
        Appointment appointmentObj2 = this.createAppointmentObject("testList");
        appointmentObj2.setIgnoreConflicts(true);
        Appointment appointmentObj3 = this.createAppointmentObject("testList");
        appointmentObj3.setIgnoreConflicts(true);
        Appointment id1 = this.ctm1.insert(appointmentObj);
        Appointment id2 = this.ctm1.insert(appointmentObj2);
        Appointment id3 = this.ctm1.insert(appointmentObj3);
        int[][] objectIdAndFolderId = new int[][]{{id1.getObjectID(), appointmentFolderId}, {id2.getObjectID(), appointmentFolderId}, {id3.getObjectID(), appointmentFolderId}};
        int[] cols = new int[]{1, 200, 2, 20, 221};
        Appointment[] appointmentArray = ListTest.listAppointment(this.getWebConversation(), objectIdAndFolderId, cols, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"check response array", (int)3, (int)appointmentArray.length);
    }

    public void testListWithNoEntries() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testList");
        appointmentObj.setIgnoreConflicts(true);
        Appointment appointmentObj2 = this.createAppointmentObject("testList");
        appointmentObj2.setIgnoreConflicts(true);
        Appointment appointmentObj3 = this.createAppointmentObject("testList");
        appointmentObj3.setIgnoreConflicts(true);
        Appointment id1 = this.ctm1.insert(appointmentObj);
        Appointment id2 = this.ctm1.insert(appointmentObj2);
        Appointment id3 = this.ctm1.insert(appointmentObj3);
        int[][] objectIdAndFolderId = new int[][]{};
        int[] cols = new int[]{1, 200, 2, 20, 221};
        Appointment[] appointmentArray = ListTest.listAppointment(this.getWebConversation(), objectIdAndFolderId, cols, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"check response array", (int)0, (int)appointmentArray.length);
    }

    public void testListWithAllFields() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testListWithAllFields");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setLocation("Location");
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setFullTime(true);
        appointmentObj.setLabel(2);
        appointmentObj.setNote("note");
        appointmentObj.setCategories("testcat1,testcat2,testcat3");
        appointmentObj.setOrganizer("someone else");
        appointmentObj.setUid("1234567890abcdef" + System.currentTimeMillis());
        appointmentObj.setSequence(0);
        int userParticipantId = ContactTest.searchContact(this.getWebConversation(), this.userParticipant2, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId), new GroupParticipant(groupParticipantId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        appointmentObj.setIgnoreConflicts(true);
        Appointment appointment = this.ctm1.insert(appointmentObj);
        int[][] objectIdAndFolderId = new int[][]{{appointment.getObjectID(), appointmentFolderId}};
        Appointment[] appointmentArray = ListTest.listAppointment(this.getWebConversation(), objectIdAndFolderId, APPOINTMENT_FIELDS, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"check response array", (int)1, (int)appointmentArray.length);
        Appointment loadAppointment = appointmentArray[0];
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long newStartTime = c.getTimeInMillis();
        long newEndTime = newStartTime + 86400000L;
        this.compareObject(appointmentObj, loadAppointment, newStartTime, newEndTime);
    }

    public void testListWithRecurrencePosition() throws Exception {
        int[] cols = new int[]{1, 200, 2, 20, 221, 207};
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testListWithRecurrencePosition" + System.currentTimeMillis());
        folderObj.setParentFolderID(2);
        folderObj.setModule(2);
        folderObj.setType(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        this.folder = this.ftm.insertFolderOnServer(folderObj);
        int publicFolderId = this.folder.getObjectID();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testListWithRecurrencePosition");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(publicFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        Appointment appointment1 = this.ctm1.insert(appointmentObj);
        Appointment appointmentObj2 = new Appointment();
        appointmentObj2.setTitle("testListWithRecurrencePosition2");
        appointmentObj2.setStartDate(new Date(startTime));
        appointmentObj2.setEndDate(new Date(endTime));
        appointmentObj2.setShownAs(3);
        appointmentObj2.setIgnoreConflicts(true);
        appointmentObj2.setParentFolderID(appointmentFolderId);
        Appointment appointment2 = this.ctm1.insert(appointmentObj2);
        Appointment[] appointmentList = new Appointment[3];
        appointmentList[0] = new Appointment();
        appointmentList[0].setObjectID(appointment1.getObjectID());
        appointmentList[0].setParentFolderID(publicFolderId);
        appointmentList[0].setRecurrencePosition(2);
        appointmentList[1] = new Appointment();
        appointmentList[1].setObjectID(appointment1.getObjectID());
        appointmentList[1].setParentFolderID(publicFolderId);
        appointmentList[1].setRecurrencePosition(3);
        appointmentList[2] = new Appointment();
        appointmentList[2].setObjectID(appointment2.getObjectID());
        appointmentList[2].setParentFolderID(appointmentFolderId);
        Appointment[] appointmentArray = AppointmentTest.listAppointment(this.getWebConversation(), appointmentList, cols, this.timeZone, this.getHostName(), this.getSessionId());
        ListTest.assertEquals((String)"3 elements expected", (int)3, (int)appointmentArray.length);
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() == appointment1.getObjectID() && appointmentArray[a].getRecurrencePosition() == 2) {
                found1 = true;
                continue;
            }
            if (appointmentArray[a].getObjectID() == appointment1.getObjectID() && appointmentArray[a].getRecurrencePosition() == 3) {
                found2 = true;
                continue;
            }
            if (appointmentArray[a].getObjectID() != appointment2.getObjectID()) continue;
            found3 = true;
        }
        ListTest.assertTrue((String)("not all objects in response : " + found1 + ":" + found2 + ":" + found3), (found1 && found2 && found3 ? 1 : 0) != 0);
    }

    public void testLastModifiedUTC() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
        int[] cols = new int[]{1, 20, 6};
        Appointment appointmentObj = this.createAppointmentObject("testShowLastModifiedUTC");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date(System.currentTimeMillis() + 3600000L));
        appointmentObj.setIgnoreConflicts(true);
        Appointment appointment = this.ctm1.insert(appointmentObj);
        ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{appointmentFolderId, appointment.getObjectID()}}), cols, true);
        CommonListResponse response = Executor.execute(client, listRequest);
        JSONArray arr = (JSONArray)response.getResponse().getData();
        ListTest.assertNotNull((Object)arr);
        int size = arr.length();
        ListTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray objectData = arr.optJSONArray(i);
            ListTest.assertNotNull((Object)objectData);
            ListTest.assertNotNull((Object)objectData.opt(2));
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm1.cleanUp();
        this.ftm.cleanUp();
        this.client1.logout();
        super.tearDown();
    }
}

