/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;

public class CreatedByTest
extends AbstractAJAXSession {
    private Appointment appointment;
    private AJAXClient client2;

    public CreatedByTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.appointment = new Appointment();
        this.appointment.setTitle("Created by Test");
        this.appointment.setStartDate(TimeTools.D("07.12.2010 09:00"));
        this.appointment.setEndDate(TimeTools.D("07.12.2010 10:00"));
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setCreatedBy(this.client2.getValues().getUserId());
        this.appointment.setIgnoreConflicts(true);
    }

    public void testInjectedCreatedBy() throws Exception {
        InsertRequest request = new InsertRequest(this.appointment, this.client.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.client.execute(request);
        insertResponse.fillObject((DataObject)this.appointment);
        GetRequest getRequest = new GetRequest(this.appointment);
        GetResponse getResponse = this.client.execute(getRequest);
        Appointment loadAppointment = getResponse.getAppointment(this.client.getValues().getTimeZone());
        CreatedByTest.assertEquals((String)"Wrong created by", (int)this.client.getValues().getUserId(), (int)loadAppointment.getCreatedBy());
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), this.appointment.getLastModified()));
        super.tearDown();
    }
}

