/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import java.io.ByteArrayInputStream;

public class ByteArray {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] bytes;
    private int start;
    private int count;

    public ByteArray(byte[] b, int start, int count) {
        this.bytes = b;
        this.start = start;
        this.count = count;
    }

    public ByteArray(int size) {
        this(new byte[size], 0, size);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getNewBytes() {
        byte[] b = new byte[this.count];
        System.arraycopy(this.bytes, this.start, b, 0, this.count);
        return b;
    }

    public int getStart() {
        return this.start;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
        if (this.bytes.length - count > 4096) {
            byte[] b = new byte[count];
            System.arraycopy(this.bytes, this.start, b, 0, count);
            this.bytes = b;
            this.start = 0;
        }
    }

    public ByteArrayInputStream toByteArrayInputStream() {
        return new ByteArrayInputStream(this.bytes, this.start, this.count);
    }

    public void grow(int incr) {
        byte[] nbuf = new byte[this.bytes.length + incr];
        System.arraycopy(this.bytes, 0, nbuf, 0, this.bytes.length);
        this.bytes = nbuf;
    }

    public void growMin(int minCapacity) {
        if (minCapacity - this.bytes.length > 0) {
            int oldCapacity = this.bytes.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = ByteArray.hugeCapacity(minCapacity);
            }
            byte[] nbuf = new byte[newCapacity];
            System.arraycopy(this.bytes, 0, nbuf, 0, this.bytes.length);
            this.bytes = nbuf;
        }
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public String toString() {
        return new String(this.bytes);
    }
}

